<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: headfoot.inc,v 1.9 2004/01/21 10:58:54 lseeker Exp $
 */

/* {{{ PrintHeader() */
function PrintHeader() {
    // html 상단부 태그 표시와 각종 잡기능(?) 수행
    global $skin, $admin_data;

    if (file_exists("skin/{$admin_data['skin']}/style.php")) {
        include("skin/{$admin_data['skin']}/style.php"); // 스킨 include
    } else {
        die("지정하신 스킨을 skin/ 디렉토리에서 찾을 수 없습니다.<br />" .
            "[<a href=\"config.php?from=./list.php\" target=\"_blank\">관리자 모드에서 스킨을 바꿔주세요.</a>]");
    }

    header('Content-Type: text/html; charset=UTF-8');

    /* 상단부 include는 현재 문서의 설정이나 스킨의 설정보다 우선적으로 수행됩니다.. */
    /* FIXME 문서형이 완전히 망가질텐데... -_-; */
    if(!empty($admin_data['include_top'])) {
        include $admin_data['include_top']; // 상단부 include
    }

    if(empty($admin_data['titlebar'])) {
        $admin_data['titlebar'] = "EtchiBBS {$GLOBALS['bbs']['version']} [{$_SERVER['PHP_SELF']}]";
    }

    echo <<<HEAD
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
  "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
 <title>{$admin_data['titlebar']}</title>
 <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
HEAD;

    PrintCSS(); // 상단부 css 데이터 include

    echo "</head><body background=\"{$admin_data['bgimage']}\" bgcolor=\"{$skin['body_bgcolor']}\" link=\"{$skin['link_color']}\" alink=\"{$skin['link_color']}\" vlink=\"{$skin['link_color']}\" text=\"{$skin['text_color']}\">";
    echo "<center>\n{$admin_data['title_text']}\n</center>\n<br>\n";
}
/* }}} */

/* {{{ PrintFooter() */
function PrintFooter() {
    // 하단부 표시
    global $admin_data, $skin;

    /* 스킨 제작자 정보 불러오기 */
    $file_open = file("skin/{$admin_data['skin']}/designed_by.txt");
    $skin['designer']     = trim($file_open[0]);
    $skin['designer_url'] = trim($file_open[1]);

    /* 페이지 하단부 게시판 정보 테이블 표시 */
    echo <<<BBSINFO
<address style="background-color: {$skin['image_table_bgcolor']}; text-align: center; margin: 2px 30%; width: 40%; font-style: normal; font-size: x-small; line-height: 1.4em">
 EtchiBBS {$GLOBALS['bbs']['version']} &copy; 2004 <a href="http://etchibbs.kldp.net">EtchiBoard Project</a><br />
 Skin designed by <a href="{$skin['designer_url']}">{$skin['designer']}</a>
</address>
BBSINFO;

    if(!empty($admin_data['include_bottom'])) include $admin_data['include_bottom'];

    /* html 코드 마감 */
    echo "</body>\n</html>";
}
/* }}} */

?>
