<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: list.php,v 1.18 2004/01/23 02:18:09 lseeker Exp $
 */

require 'lib/admin.inc'; // 관리자 환경설정 include
include 'lib/headfoot.inc'; // 페이지 상/하단부 출력
include 'lib/list.inc'; // 글 목록 function
include 'lib/message.inc'; // 메시지 function

PrintHeader(); // 헤더 출력, ...

/* {{{ 쿠키값 받기 */
$cookie_name = isset($_COOKIE['etchibbs_name']) ? $_COOKIE['etchibbs_name'] : '';
$cookie_mail = isset($_COOKIE['etchibbs_mail']) ? $_COOKIE['etchibbs_mail'] : '';
$cookie_home = isset($_COOKIE['etchibbs_home']) ? $_COOKIE['etchibbs_home'] : '';
if (get_magic_quotes_gpc()) {
    $cookie_name = stripslashes($cookie_name);
    $cookie_mail = stripslashes($cookie_mail);
    $cookie_home = stripslashes($cookie_home);
}
/* }}} */

# 현재 페이지 구하기 (넘겨진 변수 포함)
$page_this = isset($_SERVER["REQUEST_URI"]) ? $_SERVER['REQUEST_URI'] : $_SERVER['PHP_SELF'] . '?' . $_SERVER['QUERY_STRING'];

$page_this = rawurlencode(str_replace('&', '%26', $page_this));

# 이미지 파일 총 용량 읽어오기
$file_open = file("db/img/dbinfo");
$db_size = trim($file_open[1]);

if($db_size <= 1048576) {
    $db_size = (float)($db_size/1024);
    $db_size = sprintf("%01.2f", $db_size) ." KB";
}
else if($db_size >= 1048577) {
    $db_size = (float)($db_size/1024/1024);
    $db_size = sprintf("%01.2f", $db_size) ." MB";
}

// 전체 게시물 갯수 구하기
$fileidx = &DB::result(DB::query('SELECT max(idx) FROM hboard_db_article', $dbconn), 0, 0);

// 삭제된 게시물 구하기
/* FIXME DB에 대고 count(*) WHERE deleted='t'? ... 살려주세요. 부하가 너무 커요.
 * admin 테이블에서 조작할 수 있는 부분을 뒤적여야 할듯.
 * 가능성 있는건 현재 미지원인 article_max의 활용,
 * 혹은 비교적 범위가 작은 app를 활용. (*100? 2^31까지니 무리는 없을듯?)
 */
$deleted_fileidx = &DB::result(DB::query('SELECT count(*) FROM hboard_db_article WHERE deleted=\'t\'', $dbconn), 0, 0);

DB::close($dbconn);

## 페이지 확인 부분
$page = empty($_REQUEST['page']) || !is_numeric($_REQUEST['page']) ? 1 : $_REQUEST['page']; // 입력받지 않았으면, 자동으로 1로 설정하기

# 읽어들인 인덱스를 이용해 페이지 넘기기
$startpage = intval($fileidx / $admin_data['app'] + 0.99);
if ($startpage < 1) $startpage = 1;

$footart = $fileidx - $admin_data['app'] * $page; // 현재 페이지의 최하단 게시물
$headart = $footart + $admin_data['app']; // 현재 페이지의 최상단 게시물

if ($page < 0) PrintMessage("페이지가 지정된 범위를 초과했습니다.", "error");
elseif ($page > $startpage) PrintMessage("페이지가 지정된 범위를 초과했습니다.", "error");
else {
    /* TODO LIST SKIN? include 'skin/' . $admin_data['skin'] . '/list.php'; */
?>

<!-- {{{ JS -->
<script type="text/javascript"> 
<!--
function Preview(Change_form,i){
    var strPath;
    d_pic = "d_pic1";
    document.all(d_pic).innerHTML="<IMG alt='Preview' border=0 name=pic1 src='" + eval("Change_form.picture.value") + "' style='visibility:hidden'>";
    stretch_i="stretchimage('320','240','1')";
    window.setTimeout(stretch_i,1000);
}

function stretchimage(iw,ih,j){
    iWidth=parseInt(eval("document.pic"+j+".width"));
    iHeight=parseInt(eval("document.pic"+j+".height"));
    if(iWidth>parseInt(iw) && iWidth>=iHeight){
        eval('document.pic'+j+'.height=parseInt(iw)/iWidth*iHeight;');
        eval('document.pic'+j+'.width=parseInt(iw);');
    }
    else if(iHeight>parseInt(ih) && iHeight>iWidth){
        eval('document.pic'+j+'.width=parseInt(ih)/iHeight*iWidth;');
        eval('document.pic'+j+'.height=parseInt(ih);');
    }

    eval('document.pic'+j+'.style.visibility="visible";');
}

function checkvalue() {
    if(document.inputform.name.value == ""){
        alert("작성자의 이름을 기입해 주세요.");
        document.inputform.name.focus();
        return true;
    }
    else if(document.inputform.picture.value == ""){
        alert("업로드할 그림을 지정하세요.");
        document.inputform.picture.focus();
        return true;
    }
    else if(document.inputform.passwd.value == ""){
        alert("비밀번호를 입력해 주세요.");
        document.inputform.passwd.focus();
        return true;
    }
    else if(document.inputform.ne.value == ""){
        alert("게시물의 설명이나 글의 내용을 입력해 주세요.");
        document.inputform.ne.focus();
        return true;
    }
    else{
        document.inputform.submit();
    }
}

function checksearch() {
    if
    (document.searchform.search_word.value == ""){
        alert("검색어를 입력해 주세요.");
        document.searchform.search_word.focus();
        return true;
    }
    else {
        document.searchform.submit();
    }
}

function Openwindow(name, url, left, top, width, height, toolbar, menubar, statusbar, scrollbar, resizable)
// script from Namo Webeditor
{
    toolbar_str = toolbar ? 'yes' : 'no';
    menubar_str = menubar ? 'yes' : 'no';
    statusbar_str = statusbar ? 'yes' : 'no';
    scrollbar_str = scrollbar ? 'yes' : 'no';
    resizable_str = resizable ? 'yes' : 'no';
    window.open(url, name, 'left='+left+',top='+top+',width='+width+',height='+height+',toolbar='+toolbar_str+',menubar='+menubar_str+',status='+statusbar_str+',scrollbars='+scrollbar_str+',resizable='+resizable_str);
}
//-->
</script>
<!-- }}} -->

<!-- {{{ 글쓰기 부분 시작 -->
<table align="center" cellpadding="0" cellspacing="0" width="640">
 <tr><td width="974" height="20" background="skin/<?php echo $admin_data['skin']; ?>/title_bg.gif">
   <table cellpadding="0" cellspacing="0" width="100%">
    <tr><td width="17" height="25" background="skin/<?php echo $admin_data['skin']; ?>/title_bg.gif">
      <img src="skin/<?php echo $admin_data['skin']; ?>/write.gif" width="14" height="20" border="0" alt="write.gif">
      </td><td width="674" height="20" background="skin/<?php echo $admin_data['skin']?>/title_bg.gif">
      <font color="<?php echo $skin['sfont2_color']; ?>">&nbsp;<b>새 게시물 작성..</b></font>
    </td></tr>
   </table>
 </td></tr>

 <tr><td>
   <!-- {{{ 쓰기 폼 -->
   <form name="inputform" method="post" action="./post_article.php" enctype="multipart/form-data" onsubmit="this.submit_btn.disabled=true">

    <table border=1 width=640 cellspacing=0 cellpadding=7 bgcolor="<?php echo $skin['image_table_bgcolor']?>"><tr align=center><TD>
      <table border=0 cellpadding=0 cellspacing=0>
       <tr><td>
         <TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0>
         <TR><TD WIDTH=50>Name</TD>
         <TD><INPUT TYPE=text NAME="name" SIZE=20 MAXLENGTH=30 VALUE="<?php echo htmlspecialchars($cookie_name); ?>"></TD></TR>

         <TR><TD>Mail</TD><TD>
         <INPUT TYPE=text NAME="email" SIZE=32 MAXLENGTH=100 VALUE="<?php echo htmlspecialchars($cookie_mail); ?>"></TD></TR>

         <TR><TD>URL(*)</TD><TD>
         <INPUT TYPE=text NAME="homepage" SIZE=32 MAXLENGTH=255 VALUE="<?php echo strcmp($cookie_home, '') ? htmlspecialchars($cookie_home) : ''; ?>">
         </TD></TR>

         <TR><TD>File</TD><TD>
         <INPUT TYPE=file NAME="picture" SIZE=20 MAXLENGTH=255 onChange="Preview(this.form, 1);">
         <span style="font-size:8pt;">
<?php
if($admin_data['fileup_max'] != '0') {
    // 파일 업로드 제한이 있을 경우: KB, MB 단위로 변환해서 뿌리기
    if($admin_data['fileup_max'] <= 1023999) $fileup_max = intval($admin_data['fileup_max']/1024+0.5) . "KB";
    else $fileup_max = sprintf("%0.2f", $admin_data['fileup_max']/1024/1024) ."MB";
    echo "(" .$fileup_max ." <font color=\"red\">MAX</font>)";
} else {
    echo '<span style="color: red">(Unlimited)</font>';
}
?>
         </span>
         </TD></TR>

         <TR><TD>Password</TD>
         <TD><INPUT TYPE="password" NAME="passwd" SIZE=9 MAXLENGTH=30></TD></TR>

         <TR><TD WIDTH=50>Title</TD><TD>
         <input type=text name="title" size=32 maxlength=255 value=""></TD></TR>
         </TABLE>

         <TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0>
         <TR><TD><TEXTAREA NAME="ne" ROWS=7 COLS=45></TEXTAREA></TD></TR>
         </TABLE>

         <TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0 WIDTH="100%">
         <TR><TD ALIGN=CENTER>
         <INPUT name="submit_btn" type=button value="Submit" onclick="checkvalue();" accesskey=s>&nbsp;<INPUT name="reset_btn" TYPE=reset VALUE="Reset">
         </TD></TR>
         </TABLE>
        </form>
      </td></tr>
     </table>

     <TD WIDTH=320 HEIGHT=240>
     <DIV id='d_pic1' style='width:320px;height:240px;overflow:hidden;' align='center'>
     <IMG border='0' name='pic1' SRC='skin/<?php echo $admin_data['skin']?>/preview.jpg' WIDTH='320' HEIGHT='240' alt='Preview'>
     </DIV>

     </TD></tr>
    </table>
  </td></tr>
 </table>
 <!-- }}} 쓰기 폼 끝 -->
 <!-- 글쓰기 부분 끝 }}}-->
 <center>
  <br>
  <table align="center" width="90%" cellpadding="0" cellspacing="0" bgcolor="<?php echo $skin['image_table_bgcolor']?>">
   <tr><td width="37">
     <p align="center"><span style="font-size:9pt;">
      <img src="skin/<?php echo $admin_data['skin']; ?>/info.jpg" width="32" height="32" alt="Info"></span></p>
    </td>
    <td>
     <p><span style="font-size:9pt;">총 <?php echo $fileidx - $deleted_fileidx; ?>개의 게시물이 등록되어 있습니다. (삭제된 게시물 <?php echo $deleted_fileidx; ?>개)<br>현재 <?php echo $page; ?> 페이지 / 전체&nbsp;<?php echo $startpage; ?>&nbsp;페이지 (페이지당 <?php echo $admin_data['app']; ?>개씩 출력, 이미지 DB: <?php echo $db_size; ?>)</span></p>
    </td>

    <td width="37">
     <p><span style="font-size:9pt;"><a href="#search" title="검색"><img src="skin/<?php echo $admin_data['skin']?>/search.jpg" width="32" height="32" alt="검색" border="0"></a></span></p>
    </td>

<?php
/* {{{ 관리자 로그인 상태 처리부분 */ 
if(isset($_COOKIE['hboard_admin_login']) && $_COOKIE['hboard_admin_login'] == $admin_data['passwd']) {
?>

<td width="37">
 <p><span style="font-size:9pt;"><a href="javascript:Openwindow('hb_config', 'config.php?from=<?php echo $page_this; ?>', 30, 30, 700, 610, 0, 0, 0, 1, 1)" title="게시판 환경 설정"><img src="skin/<?php echo $admin_data['skin']?>/config.jpg" width="32" height="32" alt="게시판 환경 설정" border="0"></a></span></p>
</td>
<td width="37">
 <p><span style="font-size:9pt;"><a href="javascript:Openwindow('hb_iconman', 'iconman.php', 60, 60, 610, 400, 0, 0, 0, 1, 1)" title="아이콘 관리자"><img src="skin/<?php echo $admin_data['skin']; ?>/addicon.jpg" width="32" height="32" alt="아이콘 관리자" border="0"></a></span></p>
</td>
<td width="37">
 <p><span style="font-size:9pt;"><a href="admin_logout.php?from=<?php echo str_replace('%2526', '%26', $page_this); ?>" title="관리자 로그아웃"><img src="skin/<?php echo $admin_data['skin']?>/logout.jpg" width="32" height="32" alt="관리자 로그아웃" border="0"></a></span></p>
</td>

<?php
} else {
?>

<td width="37">
 <p>
 <a href="javascript:Openwindow('hb_login', 'admin.php?from=<?php echo $page_this; ?>', 50, 50, 360, 80, 0, 0, 0, 0, 0);"
  title="관리자 로그인"><img src="skin/<?php echo $admin_data['skin'];?>/login.jpg"
  width="32" height="32" alt="관리자 로그인" border="0"></a>
 </p>
</td>

<?php
}
/* }}} */ 
?>
</tr></table>
<br>
<!-- 출력부분 시작 -->
<?php
if ($fileidx <= 0) {
    echo "<br><font size=5>데이터가 없습니다!</font><br><font size=3>상단의 입력폼에서 게시물을 작성하여 주십시오.</font><br><br><hr color=\"{$skin['hr_color']}\" width=\"90%\"><br>\n";
} else {
    // PrintArticle 형식 변경: PrintArticle(시작,끝,true/false) 식으로.. -.-
    PrintArticle($headart, $footart + 1, true);
}

echo "현재 <b><font color=blue>" .$page ."</font></b> 페이지 <font color=green>/</font> 전체 <b><font color=red>" .$startpage ."</font></b> 페이지<br>";

if($page>1) {
    echo "<a href=\"list.php?page=1\" title=\"첫 페이지\">|</a>&nbsp;<a href=\"list.php?page=" .($page-1) ."\" title=\"이전 페이지\">◁</a>&nbsp;&nbsp;";
} else {
    echo "<font color=\"{$skin['image_table_bgcolor']}\"><a title=\"첫 페이지\">|</a>&nbsp;<a title=\"이전 페이지\">◁</a></font>&nbsp;&nbsp;";
} // 이전 페이지랑 첫 페이지 버튼

// 미친 for문 부분 시작
for($pagecnt=($page-4);; $pagecnt++) {
    if($pagecnt<=0) { }
    else if($pagecnt>=$page) {
        break; }
        else {
            echo "<a href=\"list.php?page=" .$pagecnt ."\">[" .$pagecnt ."]</a>&nbsp;"; }
        }

        echo "[<b>" .$page ."</b>]&nbsp;";

        for($pagecnt=($page+1);; $pagecnt++) {

            if($page<=4) { // 첫 페이지라면?
            if($pagecnt>$startpage) { break; } // 끝에 닿으면 정지
            else if($pagecnt>=(($page+10)-$page)) { break; }
            else { echo "<a href=\"list.php?page=" .$pagecnt ."\">[" .$pagecnt ."]</a>&nbsp;"; }
        }

        else { // 아님 말구 ㅡㅡ..
        if($pagecnt>$startpage) { break; } // 끝에 닿으면 정지
        else if($pagecnt>=($page+5)) { break; } // +5 도 정지
        else { echo "<a href=\"list.php?page=" .$pagecnt ."\">[" .$pagecnt ."]</a>&nbsp;"; }
    }
}

// 미친 for문 부분 끝

if(($footart+1)<=1) {
    echo "&nbsp;<font color=\"{$skin['image_table_bgcolor']}\"><a title=\"다음 페이지\">▷</a>&nbsp;<a title=\"마지막 페이지\">|</a></font>";
}

else {
    echo "&nbsp;<a href=\"list.php?page=" .($page+1) ."\" title=\"다음 페이지\">▷</a>&nbsp;<a href=\"list.php?page=" .$startpage ."\" title=\"마지막 페이지\">|</a>";
} // 다음 페이지랑 마지막 페이지 버튼..ㅡㅡ

?>
<span style="font-size:6pt;"><br><br></span>
<a name="search"></a>
<form name="searchform" action="search.php">
 <table width="314" align="center" cellpadding="0" cellspacing="0" bgcolor="<?php echo $skin['image_table_bgcolor']?>">
  <tr>
   <td width="18" height="37">
    <p align="center"><span style="font-size:9pt;">&nbsp;</span></p>
   </td>
   <td width="56" height="37">
   <p align="center"><span style="font-size:9pt;"><img src="skin/<?php echo $admin_data['skin']; ?>/search.jpg" width="32" height="32" alt="검색" border="0"></span></p>
   </td>
   <td width="79" height="37">
    <p align="center"><span style="font-size:9pt;">
     <select name="search_type" size="1">
      <option value="name">작성자</option>
      <option value="subject">글 제목</option>
      <option value="ment">글 내용</option>
      <option value="cfile">파일 이름</option>
     </select>
    </span></p>
   </td>
   <td width="120" height="37">
   <p align="center"><span style="font-size:9pt;"><input type="text" name="search_word" maxlength="50" size="15"></span></p>
   </td>
   <td width="50" height="37">
    <p align="left">&nbsp;<span style="font-size:9pt;"><input type="button" name="search_go" value="검색" onclick="checksearch();"></span>
   </td>
   <td width="15" height="37">
    <p><span style="font-size:9pt;">&nbsp;</span></p>
   </td>
  </tr>
 </table>
</form>

</center>

<!-- 출력부분 끝 -->

<?php
}
PrintFooter();
?>
