<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: install.php,v 1.11.2.2 2004/01/25 06:08:27 lseeker Exp $
 */

// 설치전 간단 체크..
header('Content-Type: text/html; charset=UTF-8');
session_start(); /* 설치 단계를 점검 */

$_SESSION['install_step'] = 0;
$error = 0;
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
 <title>EtchiBBS Installation Wizard - Step 0</title>
 <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
 <link href="internal.css" rel="stylesheet" type="text/css">
</head>

<body>
 <div id="install">
  <h1>EtchiBBS 설치 - System check</h1>
  <div id="insthead">
   <p>EtchiBBS 설치를 시작하기 전에, 먼저 문제가 발생할 수 있는 시스템 환경을 진단합니다.
   아래에서 문제점을 확인하신 후, 해당 환경을 수정하여 주십시오.</p>
  </div>
<?php
if (file_exists('dbconn.php')) {
    echo <<<ERR_OLDVER
  <p><span color="blue">ERROR :: EtchiBoard 1.0.x를 검출했습니다. (Use converter)</span><br />
  EtchiBBS Spiral을 사용하시려면 변환기를 사용하여 변환 작업을 해주세요.</p>
ERR_OLDVER;
    $error++;
}

if (file_exists('db/dbconn.php')) { 
    echo <<<ERR_ALREADY
  <p><span class="blue">ERROR :: 이미 설치가 완료된 상태입니다. (Already installed)</span><br />
  다시 설치하시려면 db디렉토리의 dbconn.php 파일을 삭제하신 후 시도하세요.</p>
ERR_ALREADY;
    $error++;
}

if (substr(phpversion(), 0, 3) < 4.2 || version_compare(phpversion(), '4.2.0', '<')) {
    echo <<<ERR_PHPVER
  <p><span class="red">ERROR :: PHP 4.2 이상에서만 작동합니다.
  (You need PHP &gt;= 4.2)</span><br />
  PHP를 업그레이드 해 주십시오.</p>
ERR_PHPVER;
    $error++;
}

if (!extension_loaded('mysql') && !extension_loaded('pgsql')) {
    echo <<<ERR_NODBMS
  <p><span class="red">ERROR :: 사용할 수 있는 DBMS가 없습니다.
  (No DBMS interface on your PHP)<br />
  PHP에서 MySQL이나 PostgreSQL을 사용할 수 있어야 합니다.</p>
ERR_NODBMS;
    $error++;
}

/* 보안을 위해 db 디렉토리를 미리 작성하고, db 디렉토리의 퍼미션을 강제함
 * DB 접속 데이터를 db 디렉토리에 저장함으로써 가능 */
umask(0111);
if (!is_dir('db') || (fileperms('db') & 03 != 03 && fileperms('db') & 030 != 030) || !touch('db/index.html')) {
    /* global이 3이면 어쨋든 쓰기 가능. group이 3이여도 OK로 처리. */
    /* 어쨋든 쓰기 불가시에는 에러 */
    echo <<<ERR_PERMISSION
  <p><span class="red">ERROR :: 디렉토리 퍼미션이 올바르지 않습니다.
  (Permission denied on DB directory)</span><br />
  chmod 명령을 사용하여 db 디렉토리의 권한을 703 이상으로 부여해 주세요.</p>
ERR_PERMISSION;
    $error++;
}

if (!$error) {
    echo <<<NO_ERROR
  <p><span class="green">SUCCESS :: 자가 진단결과 오류가 없습니다. (OK)</span><br/>
  아래 링크를 클릭하시면 설치를 시작합니다.</p>
  <p class="center">[ <a href="install_1.php">설치 마법사 시작 (Next)</a> ]</p>
NO_ERROR;

    $_SESSION['install_step'] = 1;
}
?>
  <hr />
  <address>
   EtchiBBS Spiral-0 &copy; 2004 <a href="http://etchibbs.kldp.net">EtchiBoard Project</a>
  </address>
 </div>
 <div id="instimg">
  <img src="img/install_char.jpg" width="279" height="480" alt="Welcome to EtchiBBS~" />
 </div>
</body>
</html>
