<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: search.php,v 1.27.2.4 2004/02/24 12:17:33 lseeker Exp $
 */

require 'lib/admin.inc'; // 관리자 환경설정
include 'lib/headfoot.inc'; // 상/하단부
include 'lib/list.inc'; // 글 목록 function
include 'lib/message.inc'; // 메시지 function

session_start();
PrintHeader(); // 헤더 출력

# 현재 페이지 구하기 (넘겨진 변수 포함)

/* XXX 분기가 필요한가? */
$page_this = isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : $_SERVER['PHP_SELF'] . '?' . $_SERVER['QUERY_STRING'];

$page_this = rawurlencode(rawurlencode($page_this));

if(empty($_GET['search_word'])) {
    PrintMessage("검색어를 입력해 주세요.", "error");
    PrintFooter();
    exit;
}

/* FIXME UTF-8에서는 비적합. 일단 3바이트(한글로는 1)에서 자름... ==3 */
/* 검색 방법을 바꿔서 부하는 적을텐데... 필요한걸까나? */
if (strlen($_GET['search_word']) < 3) {
    PrintMessage("검색어가 너무 짧습니다.", "error");
    PrintFooter();
    exit;
}

$search_type = $_GET['search_type']; /* PrintArticle을 위해 필요 */

if (!strcmp($search_type, 'name')) $search_type_str = '작성자';
elseif (!strcmp($search_type, 'subject')) $search_type_str = '글 제목';
elseif (!strcmp($search_type, 'ment')) $search_type_str = '글 내용';
else $search_type_str = '파일 이름';

if (!get_magic_quotes_gpc()) $_GET['search_word'] = addslashes($_GET['search_word']);
$search_word = str_replace('%', '\\\\%', $_GET['search_word']); // % 교체

if (isset($_GET['next'])) {
    $next = (int) $_GET['next'];
    if ($next < 0) die('ERROR: 잘못된 인자를 받았습니다.');
    if ($next) {
        if(!isset($_SESSION['search'][$next])) die('ERROR: 올바른 검색 순서가 아닙니다');
        $search_sql = 'idx<' . $_SESSION['search'][$next] . ' AND ';
    } else {
        $search_sql = '';
    }
} else { 
    if (isset($_SESSION['search'])) unset($_SESSION['search']);
    $next = 0;
    $search_sql = '';
    $_SESSION['search_finish'] = FALSE;
}

/* DB에서 결과 가져오기 */
$result = &DB::query("SELECT idx, name, email, home, ipaddr, date, cfile, subject, ment, deleted, reply, agent FROM hboard_db_article WHERE {$search_sql}deleted='f' AND {$search_type} LIKE '%{$search_word}%' ORDER BY idx DESC LIMIT {$admin_data['app']}", $dbconn);

$search_word = str_replace('\\\\%', '%', $search_word);

/* 검색 종료 여부 확인 */
$rows = &DB::numrows($result);
if ($rows < $admin_data['app'] || DB::result($result, $rows - 1 , 0) == 1) $_SESSION['search_finish'] = TRUE;
if ($rows) DB::resultp_reset($result);
?>
<script type="text/javascript">
<!--
function show_comment_form(n) {
    return true;
}
//-->
</script>

<!-- {{{ 검색 확인  -->
<div style="padding: 0px 5%">
<table width="100%" cellpadding="0" cellspacing="2" style="background-color: <?php echo $skin['image_table_bgcolor']; ?>; border: 1px outset <?php echo $skin['image_table_bgcolor']; ?>">
 <tr>
  <td style="line-height: 1.25em">
   <img src="skin/<?php echo $admin_data['skin']; ?>/info.jpg" width="32" height="32"
     alt="Info" style="border: 0px; float: left" />
   <?php echo $search_type_str; ?>에 대한 검색어 <b><?php echo $search_word; ?></b>(으)로 <b><?php echo $next + 1; ?></b>번째 검색 결과입니다.<br />
   [<a href="list.php"><b>목록으로 돌아가기</b></a>]
  </td>
  <td align="right">
   <a href="#search" title="검색"><img src="skin/<?php echo $admin_data['skin']?>/search.jpg"
     width="32" height="32" alt="검색" border="0" /></a>
<?php
/* {{{ 관리자 로그인 상태 처리부분 */ 
if ($admin['login']) {
?>
   <a href="javascript: Openwindow('hb_config', 'config.php?from=<?php echo $page_this; ?>', 30, 30, 700, 610, 0, 0, 0, 1, 1)" title="게시판 환경 설정"><img
     src="skin/<?php echo $admin_data['skin']?>/config.jpg" width="32" height="32"
     alt="게시판 환경 설정" border="0" /></a>
   <a href="javascript:Openwindow('hb_iconman', 'iconman.php', 60, 60, 610, 400, 0, 0, 0, 1, 1)" title="아이콘 관리자"><img
     src="skin/<?php echo $admin_data['skin']; ?>/addicon.jpg" width="32" height="32"
     alt="아이콘 관리자" border="0" /></a>
   <a href="admin_logout.php?from=<?php echo rawurldecode($page_this); ?>" title="관리자 로그아웃"><img
     src="skin/<?php echo $admin_data['skin']?>/logout.jpg" width="32" height="32"
     alt="관리자 로그아웃" border="0"></a>
<?php
} else {
?>
   <a href="javascript:Openwindow('hb_login', 'admin.php?from=<?php echo $page_this; ?>', 50, 50, 360, 140, 0, 0, 0, 0, 0);" title="관리자 로그인"><img
     src="skin/<?php echo $admin_data['skin'];?>/login.jpg" width="32" height="32"
     alt="관리자 로그인" border="0"></a>
<?php
}
/* }}} */ 
?>
  </td>
 </tr>
</table>
</div>
<!-- }}} -->

<br />
<?php
if (!$rows) {
    echo "<div style=\"text-align: center; font-size: x-large; line-height: 2em\">더이상 검색 결과가 없습니다.</div>\n";
} else {
    while ($article = &DB::fetch($result)) {
        $_SESSION['search'][$next + 1] = $article['idx']; /* 다음 검색을 시작할 idx값 */
        PrintArticle($article, TRUE);
    }
    DB::free($result);
}
DB::close($dbconn);

echo '<div style="text-align: center">';
$search_count = isset($_SESSION['search']) ? count($_SESSION['search']) : 0;
for ($i = 0; $i < $search_count; $i++) {
    if ($i == $next) echo '<b>';
    echo "[<a href=\"search.php?search_type={$search_type}&amp;search_word=" . rawurlencode($search_word) . "&amp;next={$i}\">" . ($i + 1) . '</a>] ';
    if ($i == $next) echo '</b>';
}

if (!$_SESSION['search_finish']) {
    echo "[<a href=\"search.php?search_type={$search_type}&amp;search_word=" . rawurlencode($search_word) . "&amp;next={$search_count}\"><b>다음 검색 결과</b></a>]\n";
}

/* 검색폼에서 미리 선택된 검색방식.. */
/* E_NOTICE 처리 */
$option['name'] = $option['subject'] = $option['ment'] = $option['cfile'] = '';
$option[$_GET['search_type']] = ' selected="selected"';

/* {{{ 출력부 */
?>
</div>
<br />
<!-- {{{ 검색폼 -->
<form action="search.php" onsubmit="return checkform_search(this);">
<div id="search">
<table align="center" cellpadding="2" cellspacing="2" style="background-color: <?php echo $skin['image_table_bgcolor']; ?>; padding: 0px 24px">
 <tr>
  <td align="right"><img src="skin/<?php echo $admin_data['skin']; ?>/search.jpg" width="32" height="32" alt="검색" border="0" /></td>
  <td>
   <select name="search_type" size="1">
    <option value="name"<?php echo $option['name']; ?>>작성자</option>
    <option value="subject"<?php echo $option['subject']; ?>>글 제목</option>
    <option value="ment"<?php echo $option['ment']; ?>>글 내용</option>
    <option value="cfile"<?php echo $option['cfile']; ?>>파일 이름</option>
   </select>
   <input type="text" name="search_word" maxlength="50" size="15" value="<?php echo htmlspecialchars($search_word); ?>" />
   <input type="submit" value="검색" />
  </td>
 </tr>
</table>
</div>
</form>
<!-- }}} -->
<div style="text-align: center">
 <b>[<a href="list.php">목록으로 돌아가기</a>]</b>
</div>
<br />
<?php
/* }}} */
PrintFooter();
?>
