<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: install_2.php,v 1.10.2.2 2004/02/24 14:56:35 lseeker Exp $
 */

header('Content-Type: text/html; charset=UTF-8');
session_start();
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
 <title>EtchiBBS Installation Wizard - Step 2</title>
 <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
 <link href="internal.css" rel="stylesheet" type="text/css">
 <script type="text/javascript">
<!--
function checkform(form) {
    if(form.password.value == "") {
        alert("비밀번호를 입력하세요. (Fill password)");
        form.password.focus();
        return false;
    }

    if(form.pwconfirm.value == "") {
        alert("비밀번호 확인을 입력하세요. (Fill confirm)");
        form.pwconfirm.focus();
        return false;
    }

    if(form.password.value != form.pwconfirm.value) {
        alert("입력된 비밀번호 두 개가 일치하지 않습니다. (Not match)");
        return false;
    }

    return true;
}
//-->
 </script>
</head>

<body>
<?php
if (!isset($_SESSION['install_step']) || $_SESSION['install_step'] < 2 ||
        strcmp($_SERVER['REQUEST_METHOD'], 'POST')) {
    echo <<<ERR_STEP
 <p>정상적인 방법으로 설치를 진행해주십시오. (Please follow installation step)<br />
 [ <a href="install.php">설치 처음으로 (Step 0)</a> ]</p>
</body>
</html>
ERR_STEP;
    exit;
}

if (file_exists('db/dbconn.php')) {
    echo " <p class=\"red\">이미 설치가 완료된 상태입니다. (Already installed)</p>
</body>\n</html>";
    exit;
}

/* 접속 :: FIXME 오류시 자동 종료 : 오류메세지 변경 필요? */
require_once "lib/db.{$_POST['dbms']}.php";
$dbconn = &DB::connect($_POST['host'], $_POST['user'], $_POST['pass'], $_POST['dbname']);

/* FOR RELEASE */
error_reporting(E_ERROR | E_CORE_ERROR | E_COMPILE_ERROR);
if (DB::query('SELECT count(*) FROM hboard_db_admin', $dbconn) !== FALSE) {
    die('<span class="red">DB에 이미 테이블이 존재합니다. (Alreay created DB table)</span></body></html>');
}

/* 성공하면 바로 종료 */
DB::close($dbconn);

/* DB 정보를 세션으로 전달 */
$_SESSION['db_dbms'] = $_POST['dbms'];
$_SESSION['db_host'] = $_POST['host'];
$_SESSION['db_user'] = $_POST['user'];
$_SESSION['db_pass'] = $_POST['pass'];
$_SESSION['db_name'] = $_POST['dbname'];

$_SESSION['install_step'] = 3;
?>
 <div id="install">
  <h1>Enter Administrator Password</h1>
  <div id="insthead">
   <p>게시판의 관리를 위해 필요한 관리자 비밀번호를 입력해 주세요.
   (관리자 비밀번호는 별도의 관리자모드로 접근 및 게시물 수정, 삭제 등에 사용됩니다)</p>
   <p>주의 - 이 단계를 거치지 않고 게시판에 엑세스할 경우, 게시판이 정상 작동하지 않습니다.</p>
  </div>
  <form method="post" action="install_3.php" onsubmit="return checkform(this);">
   <div>
    <table id="instable" width="100%" cellpadding="2" cellspacing="1" border="0">
     <tr>
      <td>비밀번호 (password)</td>
      <td><input type="password" name="password" /></td>
     </tr>
     <tr>
      <td>확인 입력 (confirm)</td>
      <td><input type="password" name="pwconfirm" /></td>
     </tr>
     <tr>
      <td colspan="2">
       <button type="submit"><img src="img/install_ok.jpg" width="85" height="35"
        alt="OK" title="OK" /></button>
       <button type="reset"><img src="img/install_reset.jpg" width="85" height="35"
        alt="Reset" title="Reset" /></button>
      </td>
     </tr>
    </table>
   </div>
  </form>
  <hr />
  <address>
   EtchiBBS Spiral-1 &copy; 2004 <a href="http://etchibbs.kldp.net">EtchiBoard Project</a>
  </address>
 </div>
 <div id="instimg">
  <img src="img/install_char.jpg" width="279" height="480" alt="Welcome to EtchiBBS~" />
 </div>
</body>
</html>
