<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: list.php,v 1.97 2004/03/24 12:23:58 lseeker Exp $
 */

require 'lib/common.php';
include 'lib/layout.php';
include 'lib/writeform.php';
include 'lib/article.php';
include 'lib/list.inc';
include 'lib/list.class.php';

/* {{{ 전처리 */
// 이미지 파일 총 용량 읽어오기
$db_size = $admin_data['article_max'] <= 1048576 ? sprintf('%.2f KB', $admin_data['article_max'] / 1024) : sprintf('%.2f MB', $admin_data['article_max'] / 1048576);

// 전체 게시물 갯수 구하기
$fileidx =& $DB->getmaxidx();

/* 페이지 확인 부분
 * 입력받지 않았으면, 자동으로 1로 설정하기 */
$page = empty($_REQUEST['page']) ? 1 : (int) $_REQUEST['page'];

$startpage = intval($fileidx / $admin_data['app'] + 0.99);
if ($startpage < 1) $startpage = 1;

if ($page < 0 || $page > $startpage) error_exit('페이지가 지정된 범위를 초과했습니다.', TRUE);

# 읽어들인 인덱스를 이용해 페이지 넘기기
$footart = $fileidx - $admin_data['app'] * $page; // 현재 페이지의 최하단 게시물
$headart = $footart + $admin_data['app']; // 현재 페이지의 최상단 게시물
/* }}} */

$Layout = new Layout($admin_data);

$WriteForm = new WriteForm('article');
$WriteForm->readCookie();
if ($admin_data['fileup_max']) {
    $WriteForm->registerFileDesc('(' . ($admin_data['fileup_max'] < 1024000 ? sprintf('%dKB', $admin_data['fileup_max'] / 1024) : sprintf('%.2fMB', $admin_data['fileup_max'] / 1049576)) . ' <span class="fgMaxSize">MAX</span>)');
} else {
    $WriteForm->registerFileDesc('<span class="fgMaxSize">(Unlimited)</span>');
}

$ToolBox = new ToolBox;
$ToolBox->registerContent('총 ' . ($fileidx - $admin_data['deleted_num']) . "개의 게시물이 등록되어 있습니다. (삭제된 게시물 {$admin_data['deleted_num']}개)<br /> 현재 {$page} 페이지 / 전체 {$startpage} 페이지 (페이지당 {$admin_data['app']}개씩 출력, 이미지 DB: {$db_size})");
if ($admin['login']) $ToolBox->showAdminTools();

$Layout->printHeader();
/* {{{ JS */
?>
<script type="text/javascript">
<!--
var page = <?php echo $page; ?>;
var cookie_name = "<?php echo $WriteForm->name; ?>";
var cookie_mail = "<?php echo $WriteForm->email; ?>";
var cookie_home = "<?php echo $WriteForm->homepage; ?>";
var icon_list = new Array(<?php
$IconDir = dir('db/ico/');
$icon_list = array();
while ( ($filename = $IconDir->read()) !== FALSE) { 
    if ($filename != '.' && $filename != '..' && $filename != 'none.jpg' && $filename != 'index.html') $icon_list[] = '"' . htmlspecialchars($filename) . '"';
}
$IconDir->close();
echo implode(',', $icon_list);
?>);
var now_icon = "<?php echo htmlspecialchars($WriteForm->icon); ?>";
var icon_preview = '<?php echo strcmp($WriteForm->icon, '') && file_exists('db/ico/'. $WriteForm->icon) ? 'db/ico/' . rawurlencode($WriteForm->icon) : "skin/{$admin_data['skin']}/none.jpg"; ?>';
-->
</script>
<script type="text/javascript" src="commentform.js"></script>
<?php
/* }}} */
$WriteForm->show();
$ToolBox->printOut();

if (!$fileidx) {
    $DB->close();
    $Notice = new MessageBox;
    $Notice->registerTitle('안내');
    $Notice->registerMessage('<span class="fontXLarge">데이터가 없습니다!</span><br />상단의 입력폼에서 게시물을 작성하여 주십시오.');
    $Notice->printOut();
} else {
    $Result = new DBResult($DB->query("SELECT idx, name, email, home, ipaddr, date, cfile, subject, ment, deleted, reply, agent FROM hboard_db_article WHERE idx>{$footart} AND idx<={$headart} ORDER BY idx DESC"));

    $Article = new Article;
    $ArticleBox = new ArticleBox;
    $ArticleBox->readConfig($admin_data);
    $ArticleBox->registerPage($page);
    if ($admin['login']) $ArticleBox->showIPAddress();

    $Reply = new Reply($DB->query("SELECT * FROM hboard_db_comment WHERE article>{$footart} AND article<={$headart} ORDER BY article DESC, idx ASC"));
    $DB->close();
    $Reply->prepareNext();
    $ArticleBox->registerReply($Reply);

    while ($Article->readDB($Result->fetch())) {
        $ArticleBox->registerArticle($Article);
        $ArticleBox->printOut();
    }
    $Result->free();
    $Reply->free();
}

$Paging = new Paging;
$Paging->registerAddress('list.php?page=');
$Paging->registerTotalNum($fileidx);
$Paging->registerNowPage($page);
$Paging->registerNumPerPage($admin_data['app']);

$SearchForm = new SearchForm;

$Paging->printOut();
$SearchForm->printOut();
$Layout->printFooter();

?>
