<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: post_article.php,v 1.29.2.1 2004/04/11 16:17:41 lseeker Exp $
 */

require 'lib/admin.inc'; // 관리자 환경설정
include 'lib/headfoot.inc'; // 상/하단부
include 'lib/message.inc'; // 메시지 function

/* 필수 점검사항 점검!
   파일 크기, 폼 입력요소 등을 여기서 점검해 줍니다. */

// 공백 처리: ^^+
$name     = &remove_space($_POST['name']);
$title    = &remove_space($_POST['title']);
$homepage = &remove_space($_POST['homepage']);
$email    = &remove_space($_POST['email']);

if (get_magic_quotes_gpc()) {
    $name        = stripslashes($name);
    $email       = stripslashes($email);
    $homepage    = stripslashes($homepage);
} else {
    $title       = addslashes($title);
    $_POST['ne'] = addslashes($_POST['ne']);
}

/* {{{ 오류 처리 */
/* 그림 크기가 관리자가 제한한 크기보다 클 경우 (0은 무제한 의미이므로 생략..) */
if($admin_data['fileup_max'] != "0" && $_FILES['picture']['size'] > $admin_data['fileup_max']) {
    $fileup_max_in_kb = (int)(($admin_data['fileup_max']/1024+0.5));
    PrintHeader();
    PrintMessage("<b>파일의 크기가 너무 큽니다!</b><br>※ 파일의 크기는 최대 {$fileup_max_in_kb}KB로 제한됩니다.", "error");
    PrintFooter();
    exit;
}

if ($name == '' || $_FILES['picture']['tmp_name'] == '' || !strcmp($_POST['passwd'], '') || $_POST['ne'] == '') {
/* 이름, 그림파일, 비밀번호가 등록되지 않았을 때.. */
    PrintHeader();
    PrintMessage("<b>데이터가 모두 전송되지 않았습니다.</b><br>※ 필요한 폼에 데이터를 모두 채워주세요.", "error");
    PrintFooter();
    exit;
}
/* }}} */
/* 전부 정상이라면.. */

/* {{{ 쿠키 설정 */
$c_time = time() + 2592000;
setcookie('etchibbs_name', $name,     $c_time);
setcookie('etchibbs_mail', $email,    $c_time);
setcookie('etchibbs_home', $homepage, $c_time);
/* }}} */

PrintHeader();

if($homepage == 'http://') $homepage = ''; // http://일 경우 그냥 홈페이지 비우기

/* 그림파일 처리부분 #1 */
// 파일 중복 체크기능: v1.0.1 ~
$picture_md5 = md5_file($_FILES['picture']['tmp_name']);
if ($admin_data['backdrum'] == 't') {
    /* 쿼리를 한번으로 처리 */
    $result = &DB::query("SELECT idx, cfile FROM hboard_db_article WHERE md5='{$picture_md5}' AND deleted='f'", $dbconn);

    if (DB::numrows($result) != 0) {
        $backdrum['idx'] = &DB::result($result, 0, 0); // idx
        $backdrum['cfile'] = &DB::result($result, 0, 1); // cfile

        PrintMessage("<b>{$backdrum['idx']}번 글에서 같은 파일이 발견되었습니다.</b><br>\n<a href=\"search.php?search_word={$backdrum['cfile']}&amp;search_type=cfile#{$backdrum['idx']}\" target=\"_blank\">[여기를 클릭하시면 {$backdrum['idx']}번 글을 확인합니다. (검색모드)]</a><br>", "error"); // 중복시 에러발생

        unlink($_FILES['picture']['tmp_name']);
        PrintFooter();
        exit; // 죽어랏 -_-
    }
}

// user agent, ip주소 받기
$user_agent = addslashes($_SERVER['HTTP_USER_AGENT']);
$ip_addr    = $_SERVER['REMOTE_ADDR'];

// db 처리
mt_srand(microtime() * 1e6);
$salt = chr(mt_rand(0x21, 0x7E)) . chr(mt_rand(0x21, 0x7E));
$passwd = addslashes(crypt($_POST['passwd'], $salt));
$now_date = date("Y/m/d H:i:s");

$name     = addslashes($name);
$email    = addslashes($email);
$homepage = addslashes($homepage);

umask(0111);

/* {{{ DB 업데이트 */
ignore_user_abort(TRUE); /* 비정상 종료 방지 */
DB::begin($dbconn, FALSE);
DB::query("INSERT INTO hboard_db_article
    (name, email, home, ipaddr, passwd, date, subject, ment, deleted, reply, agent, md5) VALUES
    ('{$name}', '{$email}', '{$homepage}', '{$ip_addr}', '{$passwd}', '{$now_date}', '{$title}',
    '{$_POST['ne']}', 'f', '0', '{$user_agent}', '{$picture_md5}')", $dbconn);

/* 그림파일 처리부분 #2 */

// ($pic_bodynumber는 게시물 번호 1을 00001 등으로 재지정받는 변수)
$article_no = &DB::getinsertidx($dbconn);
$pic_bodynumber = str_pad($article_no, 6, '0', STR_PAD_LEFT);

// 그림파일명 선언.. (확장자는 type로 받자..ㅡㅡ)
if ($_FILES['picture']['type'] == 'image/gif') {
    $pic_filename = date('Y_m_d') . '_' . $pic_bodynumber . '.gif';
} elseif ($_FILES['picture']['type'] == 'image/pjpeg' || $_FILES['picture']['type'] == 'image/jpeg') {
    $pic_filename = date('Y_m_d') . '_' . $pic_bodynumber . '.jpg';
} elseif ($_FILES['picture']['type'] == 'image/x-png' || $_FILES['picture']['type'] == 'image/png') {
    $pic_filename = date('Y_m_d') . '_' . $pic_bodynumber . '.png';
} elseif ($_FILES['picture']['type'] == 'image/bmp') {
    $pic_filename = date('Y_m_d') . '_' . $pic_bodynumber . '.bmp';
} else {
    $pic_filename = date('Y_m_d') . '_' . $pic_bodynumber . '.unknown';
}
move_uploaded_file($_FILES['picture']['tmp_name'], 'db/img/' . $pic_filename);

DB::query("UPDATE hboard_db_article SET cfile='{$pic_filename}' WHERE idx={$article_no}", $dbconn);
DB::commit($dbconn, FALSE);
DB::close($dbconn);
/* }}} */

// 이미지 db 정보에 용량 추가하기
/* TODO 이건 어떻게든 DBMS로 옮겨야... 동시성 문제 */
$file_open = file('db/img/dbinfo');
$db_size = trim($file_open[1]);
$db_size = ($db_size + $_FILES['picture']['size']);
$fp = fopen('db/img/dbinfo', 'w');
flock($fp, LOCK_EX); /* XXX 별 도움은 안되지만 없는거보단 나으려니... */
fwrite($fp, "[size]\n{$db_size}");
flock($fp, LOCK_UN);
fclose($fp);

// 메시지 출력 (마지막 단계)
$page = 1;
PrintMessage('게시물 저장을 완료했습니다.', 'notice');
PrintFooter();
?>
