<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: article.php,v 1.12.2.3 2004/04/11 07:06:19 lseeker Exp $
 */

define('FILETYPE_CHECK',   1 << 0);
define('FILETYPE_GIF',     1 << 1);
define('FILETYPE_JPG',     1 << 2);
define('FILETYPE_PNG',     1 << 3);
define('FILETYPE_BMP',     1 << 6);
define('FILETYPE_TIFF',    1 << 7);
define('FILETYPE_UNKNOWN', 1 << 9);

/* {{{ Article Class */
class Article {
    var $no = 0;

    var $name;
    var $email;
    var $homepage;

    var $subject;
    var $content;
    var $image;

    var $ip;
    var $useragent;
    var $password;

    var $date;
    var $reply_count;
    var $deleted;

    function readDB(&$fetched) {
        if ($fetched === FALSE) return NULL;

        $this->no = $fetched['idx'];

        $this->name     =& $fetched['name'];
        $this->email    =& $fetched['email'];
        $this->homepage =& $fetched['home'];

        $this->subject =& $fetched['subject'];
        $this->content =& $fetched['ment'];
        $this->image   = 'db/img/' . $fetched['cfile'];

        $this->ip        =& $fetched['ipaddr'];
        $this->useragent =& $fetched['agent'];

        $this->date        =& $fetched['date'];
        $this->deleted     = $fetched['deleted'] == 't' ? TRUE : FALSE;
        $this->reply_count = $fetched['reply'];

        $this->password  = NULL;
        return TRUE;
    }

    function readPost() {
        if (!get_magic_quotes_gpc()) {
            $_POST['name']     = addslashes($_POST['name']);
            $_POST['homepage'] = addslashes($_POST['homepage']);
            $_POST['email']    = addslashes($_POST['email']);

            $_POST['title'] = addslashes($_POST['title']);
            $_POST['ne']    = addslashes($_POST['ne']);
        }

        $this->name     =& remove_space($_POST['name']);
        $this->email    =& remove_space($_POST['email']);
        $this->homepage =& remove_space($_POST['homepage']);

        $this->subject =& remove_space($_POST['title']);
        $this->content =& $_POST['ne'];

        if (!strcmp($this->homepage, 'http://')) $this->homepage = '';

        $this->useragent = addslashes($_SERVER['HTTP_USER_AGENT']);
        $this->ip        =& $_SERVER['REMOTE_ADDR'];
        $this->password  = empty($_POST['passwd']) ? NULL : $_POST['passwd'];

        $this->date  = date('Y/m/d H:i:s');
        $this->no    = empty($_POST['article_no']) ? 0 : (int) $_POST['article_no'];
        $this->image = empty($_FILES['picture']['tmp_name']) ? NULL : $_FILES['picture']['tmp_name'];

    }

    function writeCookie() {
        $cookie_time = time() + 2592000;
        setcookie('etchibbs_name', stripslashes($this->name),     $cookie_time);
        setcookie('etchibbs_mail', stripslashes($this->email),    $cookie_time);
        setcookie('etchibbs_home', stripslashes($this->homepage), $cookie_time);
    }

    function registerDate($date) {
        $this->date =& $date;
    }

    function writeDB() {
        /* XXX $GLOBALS['DB"] */
        if ($this->no) {
            /* On UPDATE */
            $date = $this->date . '*';
            $GLOBALS['DB']->query("UPDATE hboard_db_article SET name='{$this->name}', email='{$this->email}',home='{$this->homepage}', date='{$date}', subject='{$this->subject}', ment='{$this->content}' WHERE idx='{$this->no}'");
        } else {
            mt_srand(microtime() * 1e6);
            $password = addslashes(crypt($_POST['passwd'], chr(mt_rand(0x21, 0x7E)) . chr(mt_rand(0x21, 0x7E))));
            /* On New Article */
            $GLOBALS['DB']->query("INSERT INTO hboard_db_article (name, email, home, ipaddr, passwd, date, subject, ment, deleted, reply, agent) VALUES ('{$this->name}', '{$this->email}', '{$this->homepage}', '{$this->ip}', '{$password}', '{$this->date}', '{$this->subject}', '{$this->content}', 'f', 0, '{$this->useragent}')");
            $this->no =& $GLOBALS['DB']->getInsertIdx();
        }
    }
}
/* }}} */

/* {{{ Image Class */
class Image {
    var $file;
    var $name;
    var $width;
    var $height;
    var $type;
    var $md5;
    var $size;

    function Image($file) {
        if (!file_exists($file)) {
            trigger_error("Image file {$file} not exists", E_USER_WARNING);
            return;
        }

        $this->file = $file;
        $this->name = basename($file);
        list($this->width, $this->height, $this->type, $dummy) = getimagesize($file);
        $this->md5  = md5_file($file);
        $this->size = filesize($file);
    }

    function checkFileType(&$allowed) {
        $error = FALSE;
        switch ($this->type) {
            case 1:
                if (!($allowed & FILETYPE_GIF)) $error = 'GIF';
                break;
            case 2:
                if (!($allowed & FILETYPE_JPG)) $error = 'JPG';
                break;
            case 3:
                if (!($allowed & FILETYPE_PNG)) $error = 'PNG';
                break;
            case 6:
                if (!($allowed & FILETYPE_BMP)) $error = 'BMP';
                break;
            case 7:
            case 8:
                if (!($allowed & FILETYPE_TIFF)) $error = 'TIFF';
                break;
            default:
                if (!($allowed & FILETYPE_UNKNOWN)) $error = 'unknown';
        }

        if ($error) error_exit("{$error} 파일은 업로드 할 수 없습니다.", TRUE);
    }

    function checkMD5() {
        $Result = new DBResult($GLOBALS['DB']->query("SELECT idx, name, email, home, ipaddr, date, cfile, subject, ment, deleted, reply, agent FROM hboard_db_article WHERE md5='{$this->md5}' AND deleted='f' LIMIT 1"));

        if ($Result->numrows()) {
            include 'lib/list.inc';

            $Layout = new Layout($GLOBALS['admin_data']);
            $Layout->hideInclude();

            $Layout->printHeader();
            $Article = new Article;
            $Article->readDB($Result->fetch());
            $Result->free();

            $ErrorBox = new MessageBox;
            $ErrorBox->registerMessage("<b>{$Article->no}번 글에서 같은 파일이 발견되었습니다.</b>");
            $ErrorBox->setTypeBack();
            $ErrorBox->printOut();

            $ArticleBox = new ArticleBox;
            $ArticleBox->readConfig($GLOBALS['admin_data']);
            $ArticleBox->registerArticle($Article);
            $ArticleBox->hideButtons();
            $ArticleBox->printOut();

            echo '<p class="center">[<a href="javascript: history.back(1);">돌아가기</a>]</p>';
            $Layout->printFooter();

            unlink($this->file);
            exit;
        }
    }

    function upload($no) {
        $filename = date('Y_m_d') . '_' . str_pad($no, 6, '0', STR_PAD_LEFT);

        switch ($this->type) {
            case 1:
                $filename .= '.gif';
                break;
            case 2:
                $filename .= '.jpg';
                break;
            case 3:
                $filename .= '.png';
                break;
            case 6:
                $filename .= '.bmp';
                break;
            case 7:
            case 8:
                $filename .= '.tiff';
                break;
            default:
                $filename .= '.unknown';
        }

        umask(0111);
        move_uploaded_file($this->file, 'db/img/' . $filename);

        $GLOBALS['DB']->query("UPDATE hboard_db_article SET cfile='{$filename}', md5='{$this->md5}' WHERE idx={$no}");
        $GLOBALS['DB']->query("UPDATE hboard_db_admin SET article_max=article_max+{$this->size}");
    }

    function remove() {
        $GLOBALS['DB']->query("UPDATE hboard_db_admin SET article_max=article_max-{$this->size}");
        unlink($this->file);
    }
}
/* }}} */

?>
