// command.C
//
// This program is free software. See the file COPYING for details.
// Author: Mattias Engdegrd, 1997-1999

#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include <qlabel.h>
#include <qlayout.h>
#include <qaccel.h>
#include <qmessagebox.h>

#include "command.h"
#include "qps.h"
#include "proc.h"
#include "uidstr.h"
#include "svec.cpp"
#include "dialogs.h"
#include "global.h"


int find_command(QString s)
{
	for(int i = 0; i < commands.size(); i++)
		if(s == commands[i]->name)
			return i;
	return -1;
}

// has "&" end of the string ?
bool hasAmpersand(QString cmdline)
{	
	QString str;
	int len;
	str=cmdline.stripWhiteSpace();

	if(str=="%update") return true; //internal command
	
	len = str.length();
	if (str[len-1].latin1()=='&')
		return true;
	else return false;
}

void check_command(int idx)
{

}

void check_commandAll()
{
	int i,idx;
	
	for(int i = 0; i < commands.size(); i++)
	{
		if(hasAmpersand(commands[i]->cmdline)==false)
			commands[i]->cmdline.append("&");
	}
}	

//after read ~/.qpsrc
void add_default_command()
{
	
	int idx;
	
	idx=find_command("Update");
	if (idx>=0)
		commands[idx]->cmdline="%update";		
	else	commands.add(new Command("Update","%update",true));

	/*
     *  PAUSED 
	idx=find_command("Quit");
	if (idx>=0)
		commands[idx]->cmdline="killall qps";		
	else	commands.add(new Command("Quit","killall qps",false));
	*/

	check_commandAll();
}	


void CommandButton::exec_command()
{
	int i,j,menu_id;
	menu_id=commands[find_command(cname)]->menu;
	qps->run_command(menu_id);
	//printf("DEBUG:exec_command() %s\n",cname.ascii());		
}


Command::Command(QString n, QString cmd,bool tb)
{
	//printf("Command init\n");
	name=n;
	cmdline=cmd;
	toolbar=tb;
	popup=false;

	toolbutton=new CommandButton(control_bar,name);
	//toolbutton=CommandButton(control_bar,name);
	toolbutton->setTextLabel (name) ;
	toolbutton->setUsesTextLabel ( true );
	toolbutton->setAutoRaise(true); 
	toolbutton->hide();
	QObject::connect(toolbutton, SIGNAL(clicked()),toolbutton, SLOT(exec_command()));
}

Command::~Command()
{
	toolbutton->hide();
	delete toolbutton;	
}


// dirty code...
// Description : this command need "select process"
bool Command::IsNeedProc()
{
	int i,len;
	len = cmdline.length();

	for(i = 0;i<len;) {
		int v = cmdline.find('%', i);
		if(v < 0) 
			break;
		if(++v >= len)
			break;

		char c = cmdline[v].latin1();		
		switch(c) {
			case 'p':				
			case 'c':
			case 'C':
			case 'u':
				if(cmdline.find("update",v)==v)
				{
					v+=5;
					break;
				}
				//printf("true\n");
				return true;
			default:;
				
		}
		i = v + 1;
	}
	return false;
}

void Command::call(Procinfo *p)
{
	QString s;
	QString msg;
	
	int len = cmdline.length();
	
	if(p==NULL) 
	{
		if (cmdline=="%update")
		{
			qps->forced_update();
			return;
		}
		
		s=cmdline;
	}
	else
	for(int i = 0;;) {
		int v = cmdline.find('%', i);
		if(v < 0) {
			s.append(cmdline.right(len - i));
			break;
		} else {
			s.append(cmdline.mid(i, v - i));
			if(++v >= len)
				break;
			QString subst;

			//need change to LOCALE(by fasthyun@magicn.com) 
			char c = cmdline[v].latin1();
			

			switch(c) {
				case 'p':
					subst.setNum(p->pid);
					break;
				case 'c':
					subst = p->command;
					break;
				case 'C':
					subst = p->cmdline;
					break;
				case 'u':
					subst = Uidstr::userName(p->uid);
					break;
				case '%':
					subst = "%";
					break;
			}
			s.append(subst);
			i = v + 1;
		}
	}

	int ret = system(s);
	if(ret) {
		msg = "The command:\n\n";
		msg.append(s);
		if(ret == -1) {
			msg.append("\n\nfailed with the error:\n\n");
			const char *e = (errno == EAGAIN)
				? "Too many processes" : strerror(errno);
			msg.append(e ? e : "Unknown error");
		} else if(ret & 0xff) {
			msg.append("\n\nwas terminated by signal ");
			msg.append(QString().setNum(ret & 0xff));
			msg.append(".");
		} else if(ret == 0x7f00) {
			msg.append("\n\ncould not be executed because it was not "
					"found,\nor you did not have execute permission.");
		} else {
			msg.append("\n\nexited with status ");
			msg.append(QString().setNum(ret >> 8));
			msg.append(".");
		}
		QMessageBox::warning(0, "Command Failed", msg);
	}
}

static void fixWidget(QWidget *w)
{
	w->setFixedSize(w->sizeHint());
}


CommandDialog::CommandDialog()
{
	FUNC_START
	setCaption("Edit Commands");
	QHBoxLayout *hbox = new QHBoxLayout(this,7); // TOP

	// item list
	lb = new QListBox(this);  //TOP->LEFT
	lb->setFixedWidth(80);
	hbox->addWidget(lb);
	
	QVBoxLayout *vbox = new QVBoxLayout; // TOP-> RIGHT
	hbox->addLayout(vbox);	

	QHBoxLayout *h1 = new QHBoxLayout;
	vbox->addLayout(h1);
	QLabel *l1 = new QLabel("Description:", this);
	h1->addWidget(l1);
	name = new QLineEdit(this);
	name->setFixedHeight(name->sizeHint().height());
	name->setMinimumWidth(170);
	name->setText("");
	h1->addWidget(name);
	
	QHBoxLayout *hbox2 = new QHBoxLayout;
	vbox->addLayout(hbox2);
	qcheck1 = new QCheckBox (this);
	qcheck1->setText("Toolbar");
	hbox2->addWidget(qcheck1);
//	qcheck2 = new QCheckBox (this);
//	qcheck2->setText("Popup(testing)");
//	qcheck2->setEnabled(false);
//	hbox2->addWidget(qcheck2);


	QLabel *l2 = new QLabel("Command Line:", this);
	l2->setFixedHeight(l2->sizeHint().height());
	l2->setAlignment(AlignVCenter | AlignLeft);
	vbox->addWidget(l2);

	cmdline = new QLineEdit(this);
	cmdline->setFixedHeight(cmdline->sizeHint().height());
	cmdline->setMinimumWidth(250);
	cmdline->setText("");
	vbox->addWidget(cmdline);

	QLabel *l3 = new QLabel(
			"Substitutions:\n"
			"%p\tPID\n"
			"%c\tCOMMAND\n%C\tCMDLINE\n%u\tUSER\n"
			"%%\t%\n"
			"\n", this);

    	l3->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	l3->setAlignment(AlignVCenter | AlignLeft | ExpandTabs);
	vbox->addWidget(l3);
	
	QHBoxLayout *hl = new QHBoxLayout;
	vbox->addLayout(hl);
	new0 = new QPushButton("New...", this);
	fixWidget(new0);
	hl->addWidget(new0);
	add = new QPushButton("Add...", this);
	fixWidget(add);
	hl->addWidget(add);
	del = new QPushButton("Delete", this);
	fixWidget(del);
	hl->addWidget(del);
	button_ok = new QPushButton("Ok", this);
	fixWidget(button_ok);
	hl->addWidget(button_ok);


	connect(lb, SIGNAL(clicked(QListBoxItem *)), SLOT(set_select( QListBoxItem * )));
	connect(new0, SIGNAL(clicked()), SLOT(new_cmd()));
	connect(add, SIGNAL(clicked()), SLOT(add_new()));
	connect(del, SIGNAL(clicked()), SLOT(del_current()));
	connect(button_ok, SIGNAL(clicked()), SLOT(close()));
	connect(name, SIGNAL(textChanged ( const QString & ) ), SLOT(event_name_midified(const QString &)));
	connect(cmdline, SIGNAL(textChanged ( const QString & ) ), SLOT(event_cmd_modified()));
	connect(qcheck1, SIGNAL(toggled ( bool ) ), SLOT(event_toolbar_checked(bool )));

	QAccel *acc = new QAccel(this);
	acc->connectItem(acc->insertItem(ALT + Key_W), this, SLOT(hide()));
	acc->connectItem(acc->insertItem(Key_Escape), this, SLOT(hide()));

	for(int i = 0; i < commands.size(); i++)
		lb->insertItem(commands[i]->name);

	vbox->freeze();
}

void CommandDialog::event_toolbar_checked(bool on)
{
	//name->text();
	int idx=find_command(name->text());
	if(idx>=0)
		commands[idx]->toolbar=on;

	control_bar->update_bar();
}

void CommandDialog::event_name_midified(const QString &new_name)
{
	int idx;
	FUNC_START;	
	//printf("debug:changed_description() start \n");
	idx=find_command(new_name);
	if (idx==-1)
	{
		add->setEnabled(1);
	}
	else add->setEnabled(0);
		
	//printf("debug:changed_description() end \n");
}

// if modified then call this function
void CommandDialog::event_cmd_modified()
{
	int idx;
	//if(name->text()=="") return;
	if(find_command(name->text()) < 0 ) return;
	
	idx=find_command(name->text());
	
	commands[idx]->name = name->text();
	commands[idx]->cmdline = cmdline->text();
	emit command_change();
}


//  set the description,cmdline  from current selected QListBox item
void CommandDialog::set_buttons(int index)
{
	if (index<0)
	{
		new_cmd();
		return;
	}
	
	bool sel = (lb->currentItem() >= 0);
	Command *c ;
	if(sel)
		c = commands[find_command(lb->currentText())];
	else 
		c = commands[find_command(lb->text(index))];
	name->setText(c->name);
	cmdline->setText(c->cmdline);
	del->setEnabled(sel);
}

void CommandDialog::set_select(QListBoxItem *item)
{
	FUNC_START;	

	if (item==NULL) return; //*** important 

	Command *c = commands[find_command(item->text())];

	name->setText(c->name);
	cmdline->setText(c->cmdline);
	qcheck1->setChecked(c->toolbar);
//	qcheck2->setChecked(c->popup);
	
	bool sel = (lb->currentItem() >= 0);

	if(item->text()=="Update")
		del->setEnabled(false);
	else del->setEnabled(sel);
	
}



void CommandDialog::new_cmd()
{
	name->setText("");
	cmdline->setText("");
	add->setText("Add...");
	add->setEnabled(1);
	button_ok->setEnabled(0);
	name->setFocus();
	lb->clearSelection();
}

void CommandDialog::add_new()
{
	if(name->text()=="") return;
	
	commands.add(new Command(name->text(), cmdline->text(),qcheck1->isChecked () ));
	check_commandAll(); //TEMP

	lb->insertItem(name->text());
	int idx=lb->count()-1;
	lb-> setSelected ( idx, true);
	add->setEnabled(0);
	del->setEnabled(1);
	button_ok->setEnabled(1);
	
	
	emit command_change(); 	// notice to refresh menu_commands
	control_bar->update_bar(); // ** important
}

void CommandDialog::del_current()
{
	int idx=find_command(name->text());
	if (idx>=0)
	{
		commands.remove(idx);
		lb->removeItem(lb->currentItem());

		if  ( lb->numRows()==idx ) idx--; // last item was remved!!
	
		if(idx>=0) {
			lb-> setSelected ( idx, true);
			set_buttons(idx);
		}
		else
			new_cmd();
		
		control_bar->update_bar();
		emit command_change(); 	// notice to refresh menu_commands
	}
}


