// proc.h   
// emacs, this is written in -*-c++-*- (who?)
// The Best Dirty code (by fasthyun@magicn.com) 
//
// This program is free software. See the file COPYING for details.
// Author: Mattias Engdegrd, 1997-1999

#ifndef PROC_H
#define PROC_H


#include "config.h"

#include <unistd.h>
#include <sys/time.h>

//#include <qwindowdefs.h>
#include <QString>
#include <QStringList>
#include <QHash>

#include "svec.h"

#ifdef SOLARIS
#include <inttypes.h>
#include <procfs.h>
#include <kstat.h>
#endif


int read_file(char *name, char *buf, int max);
int read_file_addNULL(char *name, void *buf, int max);

//#define F_PID 0x00000000
enum fields {
	F_PID, 
#ifdef LINUX
	F_TGID,
#endif
	F_PPID, F_PGID, F_SID, F_TTY,
#ifdef LINUX
	F_TPGID,
#endif
#ifdef MOSIX
	F_MIGR,
	F_LOCKED,
	F_NMIGS,
	F_NOMOVE,
	F_RPID,
#endif
	F_USER, F_GROUP,
	F_UID, F_EUID,
#ifdef LINUX
	F_SUID, F_FSUID,
#endif
	F_GID, F_EGID,
#ifdef LINUX
	F_SGID, F_FSGID,
#endif
	F_PRI, F_NICE,
	F_PLCY, F_RPRI,
#ifdef LINUX
	F_TMS,
	F_AFFCPU,
	F_SLPAVG,
#endif
	F_NLWP,
#ifdef SOLARIS
	F_ARCH,
#endif
	F_MAJFLT, F_MINFLT,
#ifdef LINUX
	F_TRS, F_DRS, F_STACK,
#endif
	F_SIZE,
	F_SWAP,  // Linux not correct 
	F_RSS,
#ifdef LINUX
	F_SHARE, F_DT,
#endif
	F_STAT,
	F_FLAGS,
	F_WCHAN,
	F_WCPU, F_CPU, F_MEM,F_MEM_P,
	F_START, F_TIME,
	F_CPUNUM,
	F_COMM,
	F_CWD, 
	F_ROOT, //?
	F_CMDLINE,
	F_END = -1 };

class Details;

#ifdef LINUX

class Sockinfo
{
	public:
		enum proto_t { TCP, UDP };
		proto_t proto;
		unsigned char st;
		unsigned char tr;
		unsigned local_addr;
		unsigned rem_addr;
		unsigned short local_port;
		unsigned short rem_port;
		unsigned tx_queue;
		unsigned rx_queue;
		unsigned tm_when;
		unsigned rexmits;
		int uid;		//??	
		int pid;
		int timeout;
		int inode;
};

class SockInode
{
	public:
		SockInode(int descr, unsigned long ino) : fd(descr), inode(ino) {};
		int fd;
		unsigned long inode;
};

class UnixSocket
{
	public:
		unsigned long inode;
		QString name;
		unsigned flags;
		unsigned char type;		// SOCK_STREAM or SOCK_DGRAM
		unsigned char state;	// SS_FREE, SS_UNCONNECTED, SS_CONNECTING,
		// SS_CONNECTED, SS_DISCONNECTING
};

#endif // LINUX

class Mapsinfo
{	
	public:
		unsigned long from, to;
		unsigned long offset;
		unsigned long inode;
		QString filename;		// null if name unknown
		char perm[4];		// "rwx[ps]"; last is private/shared flag
		unsigned minor, major;
};

#define OPEN_READ 1
#define OPEN_WRITE 2

class Fileinfo
{
	public:
		Fileinfo(int descr, QString name, int open_mode = 0)
			: fd(descr), filename(name), mode(open_mode) {};
		int fd;
		QString filename;		// "major:minor inode" in Linux 2.0,
		// texual description in Solaris 2.6
		unsigned mode;		// bits from OPEN_* above (Linux only)
};

class NameValue
{
	public:
		NameValue(const char *n, const char *val) : name(n), value(val) {};
		const char *name;
		const char *value;
};
#define CPU_TIMES(cpu, kind) cpu_times_vec[cpu * CPUTIMES + kind]

class SystemProc 
{
	long cpu[6];
	long cpu_prev[6];
};

class Procinfo	// Process Infomation 
{
	public:
		Procinfo(int pid);
		Procinfo(int pid, int thread);  //solaris !
		~Procinfo();
		Procinfo *ref() { refcnt++; return this; };
		void deref() { if(!--refcnt)  delete this; };

//		int readproc();		// new
		int readproc(int pid=-1);
		int readproc(int pid, int thread);
		inline void calculate_cpu();

		static void init_static();
		static int read_common();
		static void read_loadavg();

		void read_fd(int fdnum, char *path);
		bool read_fds();
		bool read_maps();
		bool read_environ();
#ifdef SOLARIS
		void read_pmap_maps();
#endif
#ifdef MOSIX
		static void check_for_mosix();
		static Svec<int> mosix_nodes();
#endif
#ifdef LINUX
		static bool read_socket_list(Sockinfo::proto_t proto, char *pseudofile);
		static void read_sockets();
		static bool read_usocket_list();
		static void read_usockets();
		static void invalidate_sockets();
#endif

		int get_policy();
		int get_rtprio();
#ifdef LINUX
		double get_tms();
		unsigned long get_affcpu();
#endif
		bool first_run; 		// for optimization 
		unsigned int modifed_bitarray; // TEST
		int pid;
        int pid_prev; 		//???

		QString command;	//COMMAND
		QString cmdline; 	//COMMAND_LINE
		QString username; 	//
		QString groupname; 	//
		QString cwd;		// null if not read
		QString root;		// null if not read

        bool accepted;      
		int test_stop;  	// for test
		int type; 		    // X,NETWORK,FILE_OPEN,TERMINAL(tty),THREAD,
		
		int uid, euid;
		int gid, egid;

		char state;
		int ppid;			// Parent's PID
		int pgrp;
		int session;        //???
		dev_t tty;

#ifdef LINUX
		int tgid;		// thread id
 	   	double tms;
		int slpavg;
   		unsigned long affcpu;

		int suid, fsuid;
		int sgid, fsgid;		
		int tpgid;
#endif
		
		unsigned long flags;
		unsigned long minflt;
		unsigned long majflt;
#ifdef LINUX
		unsigned long cminflt;
		unsigned long cmajflt;
#endif
		long utime;
		long old_utime;		// initial value = -1 ;
		long cutime;
		int priority;
		int nice;
		unsigned long starttime;// in jiffies since boot
		unsigned long wchan;

		// Memory 
		unsigned int  mem;	// user Memory define 
		unsigned long size;		// SIZE: total memory (K)
		unsigned long resident;	// RSS: pages in resident set (non-swapped) (K) 
#ifdef LINUX
		unsigned long share;	// shared memory pages (mmaped) (K)
		unsigned long trs;      // text resident set size (K)
		unsigned long lrs;		// shared-lib resident set size (K)
		unsigned long drs;		// data resident set size (K)
		unsigned long dt;		// dirty pages (number of pages, not K), obsolute in Kernel 2.6
		unsigned long stack;	// stack size (K)
#endif

		int nthreads;		// number of LWPs or tasks (in Linux words)
#ifdef SOLARIS
		int addr_bits;		// address bits (32 or 64)
#endif

		struct timeval tv;	// time when the snapshot was taken, (LINUX doesn't need this anymore)
		struct timeval old_tv;	//  Linux doesn't need this anymore !

		// Posix.1b scheduling
		int policy;		// -1 = uninitialized
#ifdef SOLARIS
		char policy_name[2];	// two first letters of scheduling class
#endif
		int rtprio;		// 0-99, higher can pre-empt lower (-1 = uninitialized)


		// Linux: the cpu used most of the time of the process
		// Solaris: the cpu on which the process last ran
		int which_cpu;
		int old_which_cpu;

		// computed %cpu and %mem since last update
		float wcpu;		// wheight cpu 
		float old_wcpu;	// wheight cpu 
		float pcpu;		// percent cpu after last update
		float pmem;

		static float loadavg[3];	// 1, 5 and 15 minutes load avgs
		static float loadQps;	 //TEST
		static int 	 qps_pid;

		// these are in kB
		static int mem_total, mem_free;		// (Kb)
		static int swap_total, swap_free;
#ifdef LINUX
		static int mem_shared, mem_buffers, mem_cached;
#endif

		// Solaris <sys/sysinfo.h> #defines CPU_xxx so we must avoid them
		enum { CPUTIME_USER,
#ifdef LINUX
			CPUTIME_NICE,
#endif
			CPUTIME_SYSTEM,
#ifdef SOLARIS
			CPUTIME_WAIT,
#endif
			CPUTIME_IDLE,
			CPUTIMES };

		// the following are pointers to matrices indexed by kind (above) and cpu
		static unsigned *cpu_times_vec;
		static unsigned *old_cpu_times_vec;

#ifdef LINUX
		// from proc/XX/cpu (in 2.2 SMP kernels)
		unsigned long *per_cpu_times; // vector of num_cpus times
		unsigned long *old_per_cpu_times; // vector of num_cpus times
#endif
		// should be moved to other class 
		static unsigned num_cpus;			// current number of CPUs
		static unsigned old_num_cpus; 		// previous number of CPUs
		static long num_process;			//  number of process
		static long num_network_process; 	//  number of network(socket) process
		static long num_opened_files; 		//  number of opened normal(not socket) files  
		static long dt_system;				//  test

		// accessors for (old_)cpu_times_vec
		static unsigned &cpu_times(int cpu, int kind)
		{ return cpu_times_vec[cpu * CPUTIMES + kind]; }
		static unsigned &old_cpu_times(int cpu, int kind)
		{ return old_cpu_times_vec[cpu * CPUTIMES + kind]; }
		static unsigned int clk_tick;
		static unsigned int boot_time;	// seconds since epoch

#ifdef LINUX
		/* 	from /proc/net/{tcp,udp,unix}  */
		static QHash<int,Sockinfo*> socks;	// tcp/udp sockets
		static bool socks_current;		// true if the socks list is current
		static QHash<int,UnixSocket*> usocks;	// unix domain sockets
		static bool usocks_current;		// true if the usocks list is current
#endif

		Svec<Fileinfo*> *fd_files;	// file names or NULL if not read
		Svec<Mapsinfo*> *maps;	// maps or NULL if not read

#ifdef LINUX
		Svec<SockInode*> sock_inodes; // socket inodes or NULL if not read
#endif

		Svec<NameValue*> environ;	// environment or NULL if not read
		char *envblock;		// malloc()ed environment data block

#ifdef SOLARIS
		unsigned long env_ofs;

		static kstat_ctl_t *kc;		// NULL if kstat not opened
#endif

		Details *detail;		// details window or NULL (backlink)

		bool selected:1;	// true if selected in current view
		bool generation:1;	// whether new or old generation (alternating)
		bool hidekids:1;	// true if children are hidden in tree view
		bool lastchild:1;	// true if last (visible) child in tree view

		Svec<Procinfo *> children;	// children or NULL if none (or uninit'ed)
		short level;		// distance from process root
		static const int MAX_CMD_LEN = 4096;
		static int page_k_shift;	// log2(pagesize / 1024)

		char refcnt;
	
		//TEST
		int	child_seq;			// 	
		int child_seq_prev;
		int abs_row;
		int abs_row_prev;
		int parent_row;

#ifdef MOSIX
		bool isremote;
		int from;
		int where;
		int remotepid;
		QString migr; 	// String explaining migration "node>" or ">node" 
		int nmigs;
		int locked;
		QString cantmove;
		static bool mosix_running;	// true if MOSIX is running
#endif
};

class Category
{
	public:
		Category(const char *heading, const char *explain)
			: name(heading), help(explain),flag_int_value(false) {};
		virtual ~Category();

		virtual int alignment() = 0;
		virtual QString string(Procinfo *p) = 0;  
		virtual int width() = 0;
		virtual int compare(Procinfo *a, Procinfo *b);

		const char *name;
		const char *help;
		int index;
		int id;
		bool flag_int_value;	// for total sum , cat_memory , cat_int
};

// COMMON 
class Cat_int : public Category
{
	public:
		Cat_int(const char *heading, const char *explain,
				int w, int Procinfo::*member);
		virtual int alignment() { return Qt::AlignRight; };
		virtual QString string(Procinfo *p);
		virtual int width() { return field_width; };
		virtual int compare(Procinfo *a, Procinfo *b);

	protected:
		int Procinfo::*int_member;
		int field_width;
};

// COMMON  for memory usage  
class Cat_memory : public Category
{
	public:
		Cat_memory(const char *heading, const char *explain,int w, unsigned long Procinfo::*member);
		virtual int alignment() { return Qt::AlignRight; };
		virtual QString string(Procinfo *p);
		virtual int width() { return field_width; };
		virtual int compare(Procinfo *a, Procinfo *b);

	protected:
		unsigned long Procinfo::*uintl_member;
		int field_width;
};


class Cat_uintl : public Category
{
	public:
		Cat_uintl(const char *heading, const char *explain, int w,
				unsigned long Procinfo::*member);
		virtual int alignment() { return Qt::AlignRight; };
		virtual QString string(Procinfo *p);
		virtual int width() { return field_width; };
		virtual int compare(Procinfo *a, Procinfo *b);

	protected:
		unsigned long Procinfo::*uintl_member;
		int field_width;
};

class Cat_hex : public Cat_uintl
{
	public:
		Cat_hex(const char *heading, const char *explain, int w,
				unsigned long Procinfo::*member);
		virtual QString string(Procinfo *p);
};

class Cat_swap : public Category
{
	public:
		Cat_swap(const char *heading, const char *explain);
		virtual int alignment() { return Qt::AlignRight; };
		virtual QString string(Procinfo *p);
		virtual int width() { return 8; };
		virtual int compare(Procinfo *a, Procinfo *b);
};

class Cat_string : public Category
{
	public:
		Cat_string(const char *heading, const char *explain,
				QString Procinfo::*member = 0);
		virtual int alignment() { return Qt::AlignLeft; };
		virtual QString string(Procinfo *p);
		virtual int width() { return -9; };
		virtual int gap() { return 8; };

	protected:
		QString Procinfo::*str_member;
};

class Cat_user : public Cat_string
{
	public:
		Cat_user(const char *heading, const char *explain);
		virtual QString string(Procinfo *p);
};

class Cat_group : public Cat_string
{
	public:
		Cat_group(const char *heading, const char *explain);
		virtual QString string(Procinfo *p);
};

class Cat_wchan : public Cat_string
{
	public:
		Cat_wchan(const char *heading, const char *explain);
		virtual QString string(Procinfo *p);
};

class Cat_dir : public Cat_string
{
	public:
		Cat_dir(const char *heading, const char *explain, const char *dirname,
				QString Procinfo::*member);
		virtual QString string(Procinfo *p);

	protected:
		const char *dir;
		QString Procinfo::*cache;
};

class Cat_cmdline : public Cat_string
{
	public:
		Cat_cmdline(const char *heading, const char *explain);
		virtual QString string(Procinfo *p);
};

class Cat_state : public Category
{
	public:
		Cat_state(const char *heading, const char *explain);
		virtual int alignment() { return Qt::AlignLeft; };
		virtual QString string(Procinfo *p);
		virtual int width() { return 6; };
		virtual int gap() { return 8; };
};

class Cat_policy : public Category
{
	public:
		Cat_policy(const char *heading, const char *explain);
		virtual int alignment() { return Qt::AlignLeft; };
		virtual QString string(Procinfo *p);
		virtual int width() { return 3; };
		virtual int gap() { return 8; };
		virtual int compare(Procinfo *a, Procinfo *b);
};

class Cat_rtprio : public Category
{
	public:
		Cat_rtprio(const char *heading, const char *explain);
		virtual int alignment() { return Qt::AlignRight; };
		virtual QString string(Procinfo *p);
		virtual int width() { return 5; };
		virtual int compare(Procinfo *a, Procinfo *b);
};

#ifdef LINUX
class Cat_tms : public Category
{
public:
    Cat_tms(const char *heading, const char *explain);
    virtual int alignment() { return Qt::AlignRight; };
    virtual QString string(Procinfo *p);
    virtual int width() { return 5; };
    virtual int compare(Procinfo *a, Procinfo *b);
};

class Cat_affcpu : public Category
{
public:
    Cat_affcpu(const char *heading, const char *explain);
    virtual int alignment() { return Qt::AlignRight; };
    virtual QString string(Procinfo *p);
    virtual int width() { return 8; };
    // virtual int compare(Procinfo *a, Procinfo *b);
};
#endif

class Cat_time : public Category
{
	public:
		Cat_time(const char *heading, const char *explain);
		virtual int alignment() { return Qt::AlignRight; };
		virtual QString string(Procinfo *p);
		virtual int width() { return 7; };
		virtual int compare(Procinfo *a, Procinfo *b);
};

class Cat_start : public Category
{
	public:
		Cat_start(const char *heading, const char *explain);
		virtual int alignment() { return Qt::AlignRight; };
		virtual QString string(Procinfo *p);
		virtual int width() { return 8; };
		virtual int compare(Procinfo *a, Procinfo *b);
};

class Cat_percent : public Category
{
	public:
		Cat_percent(const char *heading, const char *explain,
				int w, float Procinfo::*member);
		virtual int alignment() { return Qt::AlignRight; };
		virtual QString string(Procinfo *p);
		virtual int width() { return field_width; };
		virtual int compare(Procinfo *a, Procinfo *b);

	protected:
		float Procinfo::*float_member;
		int field_width;
};

class Cat_tty : public Cat_string
{
	public:
		Cat_tty(const char *heading, const char *explain);
		virtual QString string(Procinfo *p);
};

class Proc
{
	public:
		Proc();
		void refresh();
		void newproc(Procinfo *p);
		int  read_pid_tasks(int pid);

		Category *cat_by_name(const char *s);
		int  field_id_by_name(const char *s);

		QHash<int,Procinfo*> procs;	// processes indexed by pid
		//Svec<Category *> allcats;
		QHash<int,Category *> categories;

		int 	current_gen;
};
class Procview : public Proc
{
	public:
		Procview();

		static int compare(Procinfo *const *a, Procinfo *const *b);
		static int compare_backwards(Procinfo *const *a, Procinfo *const *b);
		void refresh();
		bool accept_proc(Procinfo *p); // COMMON
		void linearize_tree(Svec<Procinfo *> *ps, int level, int prow);
		void rebuild();
		void build_tree_24();	//LINUX
		void build_tree();

		void set_fields();
		void set_fields_list(int fields[]);
		void add_cat(Category *c);
		void addField(char *name);	// interface 
		void addField(int FIELD_ID,int where=-1);	// interface 
		void removeField(int FIELD_ID);
		int	 findCol(int FIELD_ID);
		void moveColumn(int col, int place); 
		void deduce_fields();
   		void fieldArrange();  
		void update_customfield();
		void saveCOMMANDFIELD();

		Procinfo* getProcinfoByPID(int pid){ return procs.value(pid,NULL);};

		Svec<Procinfo *> linear_procs;  // this is linear_proc_list for viewer
		Svec<Procinfo *> tags_kernel;
		Svec<Sockinfo *> linear_socks;  // this is linear_proc_list for viewer
		
		// root_procs contains processes without parent; normally only init, but
		// we cannot rely on this (Solaris has several parentless processes).
		// Also, if the view is restricted, all processes whose parent isn't in
		// the table.
		Svec<Procinfo *> root_procs;
		int	row_count;
		Svec<Category *> cats;
		Category *sortcat;
		int  sort_column;	// index of 
		bool reversed;		// true if sorted backwards
		bool treeview;		// true if viewed in tree form
		bool enable;

		enum procstates {ALL, OWNED, NROOT, RUNNING, HIDDEN, NETWORK} ;
		enum fieldstates {USER = HIDDEN + 1, JOBS, MEM, SCHED,CUSTOM};
		int viewproc;
		int viewfields;
		
	
		int hasF_COMM,idxF_COMM; //Test
		QStringList customfields;
		// lists of fields to be used for different views, terminated by -1:
		static int custom_fields[64];
		static int basic_fields[];
		static int basic_fields_smp[];
		static int jobs_fields[];
		static int mem_fields[];
#ifdef LINUX
		static int sched_fields[];
#endif


#ifdef MOSIX
		static int user_fields_mosix[];
		static int jobs_fields_mosix[];
		static int mem_fields_mosix[];
#endif
		static float avg_factor;		// exponential factor for averaging
		static const int cpu_avg_time = 30 * 1000;	// averaging time for WCPU (ms)
	
	private:
		static Category *static_sortcat;	// kludge: to be used by compare
};

#endif	// PROC_H
