// pstable.h				emacs, this is written in -*-c++-*-
//
// This program is free software. See the file COPYING for details.
// Author: Mattias Engdegrd, 1997-1999

#ifndef PSTABLE_H
#define PSTABLE_H


#include "proc.h"
#include <QHeaderView>
#include <QTreeView>
#include "htable.h"

class Netable : public HeadedTable
{
    Q_OBJECT
public:
	Netable(QWidget *parent,Procview *pv);
	~Netable();
  //  void set_sortcol();
   // void set_mode(bool treemode);
    //void update_customfield();
    void refresh();

	// called by super
//	bool hasSelection(){return  0;};
//	void setSortColumn(int col);
	
//	virtual bool isSelected(int row); 
//	virtual void setSelected(int row, bool sel);

protected:
    // implementation of the interface to HeadedTable
    virtual QString title(int col);
    virtual QString text(int row, int col);
	virtual int colWidth(int col);
/*   
    virtual int alignment(int col);
    virtual QString tipText(int col);
    virtual int rowDepth(int row);
    virtual NodeState folded(int row);
    virtual int parentRow(int row);
    virtual bool lastChild(int row);
	virtual char* total_selectedRow(int col);
	virtual int sizeHintForColumn(int col) const;
*/
    //void refresh_window();
   // bool refresh_sockets();
    const char *servname(unsigned port);
    QString ipAddr(unsigned addr);
    QString hostname(unsigned addr);
    void config_change();

public slots:
    void update_hostname(unsigned addr);

private:

    enum {
	COMMAND, PROTO, RECVQ, SENDQ, LOCALADDR, LOCALPORT, REMOTEADDR, REMOTEPORT,
	STATE,FD,SOCKFIELDS };
    //static TableField fields[SOCKFIELDS];

    bool doing_lookup;		// if table painted with host lookup
    static bool have_services;	// true if we have tried reading services
    static QHash<int,char*> servdict;
    Procview *procview;
};
    
class Pstable : public HeadedTable
{
    Q_OBJECT
public:
    Pstable(QWidget *parent,Procview *pv);

    void set_sortcol();
    void setProcview(Procview *pv);
    void setTreeMode(bool treemode);
    virtual void moveCol(int col, int place);
    void refresh();

	// called by super
	bool hasSelection(){return  0;};
	
	virtual bool isSelected(int row); 
	virtual void setSelected(int row, bool sel);
	virtual int totalRow();

		
public slots:
    void selection_update(const Svec<int> *row);
    //void sortcol_change(int col);
	void setSortColumn(int col);
    void subtree_folded(int row);
	void showTip(QPoint p,int index);

signals:
    void selection_changed();

protected:
    // implementation of the interface to HeadedTable
    virtual QString title(int col);
    virtual QString text(int row, int col);
    virtual int colWidth(int col);
    virtual int alignment(int col);
    virtual QString tipText(int col);
    virtual int rowDepth(int row);
    virtual NodeState folded(int row);
    virtual int parentRow(int row);
    virtual bool lastChild(int row);
	virtual char* total_selectedRow(int col);
	virtual int sizeHintForColumn(int col) const;

//virtual void drawCellContents(int row, int col, int w, int h, QPainter *p);

private:
	int sortColumn; // ProcView? 
    Procview *procview;
};


#endif // PSTABLE_H

