#ifndef MISC_H
#define MISC_H


#include <qcheckbox.h>
#include <qpainter.h>
#include <qpainter.h>
#include <qlineedit.h>
#include <qstatusbar.h>
#include <qtoolbutton.h>
#include <qcheckbox.h>
#include <qradiobutton.h> 
#include <qlabel.h> 
#include <qcombobox.h> 

#include <QMenu>
#include <QAbstractButton> 
#include <QBoxLayout> 
#include <QFrame> 
#include <QTimerEvent>
#include <QResizeEvent>
#include <QMouseEvent>
#include <QKeyEvent>

char*	userName(int uid,int euid);
char*	groupName(int gid,int egid);

void	setQpsTheme();
int		get_kernel_version();

int 	fsize(char *fname);
void 	msleep(long msec);
void 	mem_string(int kbytes, char *buf);

void 	init_xpm();
void 	init_misc(QWidget *main);
int 	pf_write(QPainter *p,int x,int y,const char *str);
int  	pf_str_width(char *str);
int  	pf_char_height();


class CrossBox : public QCheckBox
{
public:
    CrossBox(const char *text, QWidget *parent);

protected:
    virtual void drawButton(QPainter *paint);
};

class CheckMenu : public QMenu
{
public:
    CheckMenu(QWidget *parent = 0);

};


class TFrame : public QFrame
{
	Q_OBJECT
	public:
		TFrame(QWidget *parent);
		void setText(char *str);
		void draw( QPainter &p );

	protected slots:
//    		void refresh();
//  		void update(int n);
//		QToolButton *button,*button2,*button3;
//		void event_cursor_moved(QMouseEvent *e);
	protected :
		virtual void paintEvent(  QPaintEvent * event ); 
	private:
		QString text;
};



class XButton : public QAbstractButton
{
	Q_OBJECT
	public:
		XButton(QWidget *parent);
	protected slots:
//    		void refresh();
//  		void update(int n);
//		QToolButton *button,*button2,*button3;
//		void event_cursor_moved(QMouseEvent *e);
	protected :
		//virtual void drawButton 3( QPainter * ) ;
		virtual void paintEvent(  QPaintEvent * event ); 
		void resizeEvent(QResizeEvent *p);
};

class VPointer : public QWidget
{
	Q_OBJECT
	public:
		VPointer(QWidget *parent);
		QPixmap *pix;
	protected slots:
//		void event_cursor_moved(QMouseEvent *e);
	protected :
		//virtual void drawButton 3( QPainter * ) ;
		virtual void paintEvent(  QPaintEvent * event ); 
	//	void resizeEvent(QResizeEvent *p);
};


class SearchBox : public QLineEdit
{
	Q_OBJECT
	public:
		SearchBox(QWidget *parent);
		void event_cursor_moved(QMouseEvent *e);
	protected slots:
		void event_xbutton_clicked();
//    		void refresh();
//  		void update(int n);
//		QToolButton *button,*button2,*button3;
	protected:
		void keyPressEvent(QKeyEvent * e );
		void resizeEvent(QResizeEvent *);
 		void timerEvent(QTimerEvent * );
		int left_time;
		XButton *xb;
};

class StatusBar : public QStatusBar
{
	Q_OBJECT
	public:
		StatusBar(QWidget *parent);
    		void refresh();
    		void update(int n);
		QLabel *label,*label2,*label3;

};


class ControlBar : public QFrame
{
	Q_OBJECT
	public:
		QComboBox *view;
		ControlBar(QWidget *parent);
		void setMode(bool treemode);
		void update_bar();
	
	signals:
		void modeChange(bool treemode);
		void viewChange(QAction*);
		void need_refresh();

	protected slots:
		void linear_clicked();
		void view_changed(int idx);
		void tree_clicked();
		void show_thread_clicked();
		void event_search_box_changed();
		void event_command_pressed();
		void setPaused(bool);
		
//	protected:
//		void resizeEvent(QResizeEvent *);
		

	private:
		QRadioButton *b_tree, *b_linear, *b_treeT;
		QCheckBox    *check_thread;
		QBoxLayout 	*layout ;
};

QPalette  GlobalPallete();

// Draft Code 
// Description : new style 
template <class T> class List
{
public:
	struct Node 
	{
	//	public:
		Node(const T& x, Node* n=0) //:data(x),next(n)
		{	data=x;	next=n;	 }
		Node* before;
		Node* next;
		T data;
	};
	
	List() : head(0),end(0) { node_n=0;dirty=1;	}
	~List() { clear(); }

	//ok works 
	T& operator[](const int idx)
	{	
		Node *node;
		if(dirty==0)
		{
			//return *data[idx];
		}
		node=get_node_idx(idx);
		if(node==0)
			printf("List: node no exist !!! over index \n");
		return node->data;
	}

	int size() { return node_n; }
	void clear() { while (!empty()) pop_front(); }
	bool empty() { return !head; }

	void push_front(const T& x) { 
		Node* tmp = new Node(x,head); head = tmp; 
	}
	
	// draft
	void addcopy(const T x) {
		T n=new T();
		memcpy(n,x,sizeof(T));
	}

	void add(const T x) {
		Node	*node,*before,*next;
		
		//ex: first , end node 
		node = new Node(x,0);
		if(head==0)
		{
			head=node;
		}
		else
		{
			end->next=node;
		}
		node->before=end;
		node->next=0; 	//last
		end=node;
		node_n++;
	}

	//ok works
	inline	Node* get_node_idx(const int idx)
	{	
		Node* node; 
		int i=0;

		node = head; 
		while(node!=0) 
		{
			if(i==idx)
				return node;
			node=node->next;
			i++;
		}
		///for ( Node* i = head; i!= end; i=i->next )
		//	push_front(i->data);

		return 0;
	}

	//ok works
	void remove_node(Node *node)
	{
		Node *before,*next;
		if(node==0)
		{	
			printf("List:  node 0 ? \n");
			return ;
		}
		// 1. if fist node remove   head==node,before=0
		// 2. if last node remove	end== node, next=0;
		// 3. only one remove		head ==end== node, before==next==0
		before=node->before;  
		next=node->next;    
		
		// basis
		if (before!=0)
			before->next=next;
		else
			head=next;
		
		if (next!=0)
			next->before=before;
		else
			end=before;
		
		delete node->data;
		delete node;
		node_n--;
	}

	//ok works
	void remove(int idx) 
	{ 
		Node *node;
		node=get_node_idx(idx);
		if(node!=0)
		{
			remove_node(node);
		}
	}
	
	void pop_front() { 	remove(0);	}

protected :
	Node	*head;
	Node	*end;
	int  	node_n;
	int 	dirty;
};


#endif	// MISC_H
