// qps.cpp
// qps -- Qt-based visual process status monitor
// This program is free software. See the file COPYING for details.
// Author:  Mattias Engdegrd, 1997-1999

#define QPS_VERSION "1.10.4"

#include "./icon/icon.xpm" 

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/utsname.h>    // uname 
#include <signal.h>
#include <errno.h>
#include <sched.h>
#include <unistd.h> 	//for sleep


#include "qps.h"
#include "dialogs.h"
#include "lookup.h"
#include "misc.h"
#include "screenshot.h"

#include <QTimerEvent>
#include <QWidget>
#include <QMenu>
#include <QPixmap>
#include <QBitmap>
#include <QCloseEvent>
#include <QVBoxLayout>
#include <QSystemTrayIcon>
#include <QShortcut>
#include <QMenuBar>
#include <QFont>
#include <QToolTip>

#include <qnamespace.h>
#include <qapplication.h>
#include <qpainter.h>
#include <qmessagebox.h>
#include <qclipboard.h>
#include <qnamespace.h> 
//#include <q3url.h>
#include <qcheckbox.h>
#include <qstatusbar.h>
#include <qtoolbutton.h>
#include <qpalette.h> 
#include <qsessionmanager.h> 
#include <qlayout.h> 
#include <qtabwidget.h> 

#include "ui_eventdialog.h"


/*			 	Global Variable START 				*/
List<Command*>	commands;

QStringList	hidden_process;		    //testing
int		default_font_height=0;
bool 	previous_flag_show_thread_prev=false;	    // previous state
bool 	flag_show_thread=false;		    // to see informations at the thread level
int 	flag_thread_ok=true;		    // we presume a kernel 2.6.x using NPTL
bool 	flag_session_start=false;
bool 	flag_start_mini=false;		// Need 
bool	flag_refresh=true;
bool	flag_xcompmgr=false;		// compiz..
int 	num_opened_files=0;		    // testing
int		kernel_version=0;			

QString 	supasswd;
Qps 		*qps;
ControlBar 	*control_bar=NULL;
SearchBox 	*search_box=NULL;
TFrame 		*infobox=NULL;		    // testing
WatchdogDialog *watchdogDialog=NULL;
QFontComboBox *font_cb=NULL;
Screenshot *screenshot=NULL;

#include "trayicon.h"
TrayIcon *trayicon=NULL;
QString Qps::font_name="null";		//
int	Qps::font_size=0;


// for Non-ASCII Languages (chinese,japanese,korean) 
#include <qtextcodec.h> 
QTextCodec * codec = NULL;
#define UniString(str)  str //codec->toUnicode(str)
/*				END global variables 			*/

// default values of settings, overridden by $HOME/.qps-settings if present
bool 	Qps::flag_show= true ;	 //window state of last run : mini(iconic) or normal window 
bool 	Qps::flag_exit= true ;		
bool 	Qps::flag_devel= false ;
//bool 	Qps::flag_pcpu_total= true ;		// %CPU= pcpu/total_cpus
bool 	Qps::flag_pcpu_single= false ;		// %CPU= pcpu/cpu
bool 	Qps::show_file_path = FALSE;
bool 	Qps::show_cmd_path = TRUE;
bool 	Qps::show_infobar = TRUE;
bool 	Qps::show_ctrlbar = TRUE;
bool 	Qps::show_mem_bar = TRUE;
bool 	Qps::show_swap_bar = TRUE;
bool 	Qps::show_cpu_bar = TRUE;
bool 	Qps::show_load_graph = TRUE;
bool 	Qps::load_in_icon = TRUE;
bool 	Qps::auto_save_options = TRUE;
#ifdef LINUX
bool	Qps::hostname_lookup = TRUE;
bool	Qps::service_lookup = TRUE;
#endif
bool	Qps::pids_to_selection = TRUE;
bool	Qps::cumulative = FALSE;
bool	Qps::vertical_cpu_bar = FALSE; // not used
#ifdef SOLARIS
bool    Qps::normalize_nice = TRUE;
bool    Qps::use_pmap = TRUE;
#endif
bool 	Qps::tree_table = true; 
bool 	Qps::tree_gadgets = TRUE;
bool 	Qps::tree_lines = TRUE;
bool 	Qps::comm_is_magic = FALSE;  //DEL   
int 	Qps::swaplimit = 5;	// default: warn when less than 10% swap left
bool 	Qps::swaplim_percent = TRUE;


void getDefaultFont(QFont f);

Qps::Qps()
{
	field_win = 0;
	prefs_win = 0;
	command_win = 0;
    setIconSize(22,22);
	setMouseTracking(true);	
	font_cb=new QFontComboBox(this); // preload
	font_cb->setWritingSystem ( QFontDatabase::Latin );
	
	getDefaultFont(font());	
	QMenu *popup_signals = make_signal_menu();
	//connect(popup_signals, SIGNAL(activated(int)), SLOT(signal_menu(int)));
	//connect(popup_signals, SIGNAL(triggered(QAction *)), SLOT(signal_menu(int)));
	
	QAction *act;
	m_popup = new QMenu("context popup",this);
	m_popup->addAction("Renice...", 	this, SLOT(menu_renice()));
	m_popup->addAction("Scheduling...", 	this, SLOT(menu_sched()));
	m_popup->addSeparator();
	m_popup->addAction("Terminate", this, SLOT(sig_term()),Qt::Key_Delete ); // better
	m_popup->addAction("Hangup", this, SLOT(sig_hup()),Qt::ALT + Qt::Key_H);
	m_popup->addAction("Kill", this, SLOT(sig_kill()),Qt::ALT + Qt::Key_K);
	act=m_popup->addAction("Stop", this, SLOT(sig_stop())); act->setData(MENU_SIGSTOP);
	act=m_popup->addAction("Continue", this, SLOT(sig_cont())); act->setData(MENU_SIGCONT);

	m_popup->addMenu(popup_signals);
	m_popup->addSeparator();
	m_popup->addAction("View Details", 	this, SLOT(Action_Detail()));

//	connect(m_popup, SIGNAL(aboutToShow ()),this, SLOT(adjust_popup_menu()));
/// m_popup->addAction("Add to Hidden List",this, SLOT(menu_add_hiddenlist()),0,MENU_ADD_HIDDEN);
///	m_popup->addAction("Remove from Hidden List ",this,SLOT(menu_remove_hiddenlist()),0,MENU_REMOVE_HIDDEN);
//	m_popup->addSeparator();
///	m_popup->addAction("Find Parent", 	this, SLOT(menu_parent()),0,MENU_PARENT);
///	m_popup->addAction("Find Children", 	this, SLOT(menu_children()),0,MENU_CHILD);
///	m_popup->addAction("Find Descendants", this, SLOT(menu_dynasty()),0,MENU_DYNASTY);

	// Move to Pstable
	m_fields = new QMenu("Add Field",this);
	m_headpopup = new QMenu("header_popup",this);
	m_headpopup->addAction("Remove Field", this, SLOT(menu_remove_field()));
	m_headpopup->addMenu(m_fields);
	//connect(m_fields, SIGNAL(activated(int)), SLOT(add_fields_menu(int)));
	//m_headpopup->addAction("Select Field", this, SLOT(menu_custom()) );

	m_view = new QMenu("Field",this); 
	act=m_view->addAction("Custom Fields"); act->setData(Procview::CUSTOM);
	act=m_view->addAction("Basic Fields ");	act->setData(Procview::USER);
	act=m_view->addAction("Jobs Fields ");	act->setData(Procview::JOBS);
	act=m_view->addAction("Memory Fields "); act->setData(Procview::MEM);
#ifdef LINUX
	act=m_view->addAction("Scheduling Fields "); act->setData(Procview::SCHED);
#endif
	m_view->addSeparator();
	act=m_view->addAction("Select Custom Fields...",this, SLOT(menu_custom()));
	act->setData(MENU_CUSTOM);
	
	connect(m_view, SIGNAL(triggered(QAction *)),this, SLOT(view_menu(QAction *)));

	watchdogDialog = new WatchdogDialog;
	screenshot=new Screenshot();

	m_command = new QMenu("Command",this);	// filled in later
	///?? connect(m_command, SIGNAL(activated(int)), SLOT(run_command(int)));  // *** important
	m_command->addAction("WatchDog",watchdogDialog,SLOT(show()));//, m_event);
	m_command->addAction( "ScreenShot", screenshot, SLOT(show()) );

	m_options = new QMenu("Option",this);
	m_options->addAction("Update Period...", this, SLOT(menu_update()));
	m_options->addSeparator();
	act=m_options->addAction("", /* MENU_PATH */ this, SLOT(menu_toggle_path()));
 	act->setData(QVariant(MENU_PATH));
	act=m_options->addAction("", this, SLOT(menu_toggle_infobar()));
 	act->setData(QVariant(MENU_INFOBAR));
	act=m_options->addAction("", this, SLOT(menu_toggle_ctrlbar()));
 	act->setData(QVariant(MENU_CTRLBAR));
	act=m_options->addAction("", this, SLOT(menu_toggle_cumul()));
 	act->setData(QVariant(MENU_CUMUL));

	m_options->addSeparator();
	m_options->addAction("Preferences...", this, SLOT(menu_prefs())); //MENU_PREFS


	m_event = new QMenu;
	


	QMenu *m_help = new QMenu("Help",this);
//	m_help->addAction("FAQ", this, SLOT(license()));
	m_help->addAction("bug report ", this, SLOT(about()));
	m_help->addAction("About", this, SLOT(about()));
	
	//menu = new QMenuBar(this);
	menu = new QMenuBar;
	menu->addMenu(m_command);
	
	if(flag_devel)	menu->addAction("WatchDog",watchdogDialog,SLOT(show()));//, m_event);
	menu->addMenu(m_view);
	menu->addMenu(m_options);
	QLayout *layout=menu->layout();

//	if(layout==0) printf("menubar =NULL\n");
//	printf("name=%s\n",	layout->objectName().toAscii().data());
//	menu->addSeparator();
//	menu->addMenu(m_help);
	
		
	ctrlbar = new ControlBar(this);
	control_bar=ctrlbar;
	connect(ctrlbar, SIGNAL(modeChange(bool)), SLOT(set_table_mode(bool)));
	connect(ctrlbar, SIGNAL(need_refresh()), SLOT(refresh()));
	connect(ctrlbar, SIGNAL(viewChange(QAction*) ), SLOT(view_menu(QAction*)));

	context_col = -1;
	Procinfo::read_loadavg();

	procview = new Procview(); 
	pstable = new Pstable(this,procview);
	//printf("Pstable Construction finish\n");
	//pstable->setFocusProxy(search_box);
	//search_box->setFocusProxy(pstable);
	if(!read_settings()) 
	{
		//printf("default value\n");
		tree_table=true;
		set_update_period(1200);	// default
		resize(640, 370);		// default initial size
	}

	set_table_mode(tree_table); //  No pstable->refresh()
	//printf("1.procview cats.size=%d\n",procview->cats.size());
	add_default_command();
	make_command_menu();
	

	default_icon = 0;
	default_icon_set = FALSE;

	infobar = new Infobar(this);
	statusBar= new StatusBar(this); 	
	infobox	=new TFrame(this);
	infobox->hide();

	// misc. accelerators
	QShortcut *c1=new QShortcut ( Qt::CTRL + Qt::Key_Q, this, SLOT(save_quit()) );
	QShortcut *c2=new QShortcut ( Qt::CTRL + Qt::Key_L, pstable, SLOT(repaintAll()) );
	QShortcut *c3=new QShortcut ( Qt::CTRL+ Qt::Key_Space, ctrlbar->pauseButton, SLOT(click()) );

	///new QShortcut ( Qt::SPACE, ctrl, SLOT(save_quit()) );
	connect(pstable, SIGNAL(doubleClicked(int)), SLOT(open_details(int)));
	connect(pstable, SIGNAL(rightClicked(QPoint)), this, SLOT(show_popup_menu(QPoint)));
	connect(pstable->head, SIGNAL(rightClicked(QPoint, int)),this, SLOT(context_heading_menu(QPoint, int)));	
//	connect(netable, SIGNAL(rightClicked(QPoint)), this, SLOT(context_row_menu(QPoint)));
	
	selection_items_enabled = TRUE; // ????
	update_load_time = 0;
	update_menu_status();
	bar_visibility(); // need 
	
	
	QVBoxLayout *vlayout = new QVBoxLayout;
	vlayout->setMargin(0);
	vlayout->setSpacing(0);
	
	if(0)
	{
		// this not work
		QHBoxLayout *hlayout = new QHBoxLayout;
		{
		hlayout->setMargin(0);
		hlayout->addWidget(menu);
		QMenuBar *mbar=new QMenuBar(this);
		mbar->addMenu(m_help);
		mbar->setSizePolicy(QSizePolicy::Maximum,QSizePolicy::Maximum);
		hlayout->addWidget(mbar);
		}


		if(0)
		{
		//OS LOGO
		QPushButton *b=new QPushButton();b->setFlat(true);
		//int h=menu->frameSize().height(); printf("height=%d\n",h);
		//h=menu->sizeHint().height();
		//h=menu->minimumHeight();
		//h=menu->height();
		//b->setContentsMargins(0,0,0,0);
		b->setIcon(QPixmap((const char**)icon_xpm));
		//b->setIconSize(QSize(h,h));
		b->setMaximumSize ( 9,9 );
		//b->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding);
		//b->setSizePolicy(QSizePolicy::Maximum,QSizePolicy::Maximum);
		hlayout->addWidget(b);
		}

		vlayout->addLayout(hlayout);
	}
	else{
		menu->addMenu(m_help);
	 	vlayout->addWidget(menu);
	}
	//vlayout->setMenuBar(menu);
	vlayout->addWidget( infobar);
	vlayout->addWidget( ctrlbar);
	
	//if(flag_devel){
	if(0){
		QTabWidget *tbar = new QTabWidget(this);
		//tbar->setMargin(2);
		tbar->addTab(pstable, " &Process ");
		tbar->addTab(0, "&Files ");
		tbar->addTab(0, "&Modules ");
		tbar->addTab(0, "&Users ");
		netable = new Netable(this,procview);
		tbar->addTab(netable, " &Network ");
		vlayout->addWidget(tbar);
		connect(tbar,SIGNAL(currentChanged (int)),SLOT(tabChanged(int)));

	}
	if(0){
		QSplitter *splitter = new QSplitter(Qt::Vertical);
		QDockWidget *dock = new QDockWidget(tr("Detail"), this);
		dock->setFeatures ( QDockWidget::DockWidgetClosable );
		//dock->setWidget();
		//dock->setAllowedAreas(Qt::LeftDockWidgetArea | Qt::RightDockWidgetArea);
		//customerList = new QListWidget(dock);
		//vlayout->addStretch();
		splitter->addWidget(pstable);
		splitter->addWidget(dock);
		vlayout->addWidget( splitter);
		vlayout->addWidget( statusBar);
		setLayout(vlayout);

	}
	else
	{
		netable=NULL;
		vlayout->addWidget(pstable);
		vlayout->addWidget(statusBar);
		setLayout(vlayout);
		//vlayout->addWidget( pstable);
	}
	
	//printf("menubar1=%x\n",v_layout->menuBar () );
	//printf("menubar2=%x\n",v_layout->mainWidget () );
	//printf("menubar2=%x\n",menu);
	//printf("menu.layout=%x\n",menu->layout());
	//default_font_height=fontMetrics().height();
	//if((default_font_height>16 and font_size==0)  or font_name=="null")
	if(font_size==0  or font_name=="null")
	{
		font_name=QApplication::font().family();
		font_size=QApplication::font().pointSize();
	}
	
	procview->enable=true;
	pstable->refresh();
	if(update_period != eternity)
		startTimer(update_period);

///	setFocusPolicy (Qt::WheelFocus); 
}

// explicit destructor needed for gcc
Qps::~Qps()
{}
void Qps::tabChanged(int idx)
{
	if(idx==0) {
		procview->viewproc=Procview::ALL;
		pstable->refresh();
		pstable->update();
	}
	else 
    if(idx==1)
	{
		procview->viewproc=Procview::NETWORK;
		netable->refresh();
		netable->update();
	}
}
// return true if all selected processes are stopped
bool Qps::all_selected_stopped()
{
	for(int i = 0; i < procview->linear_procs.size(); i++) {
		Procinfo *p = procview->linear_procs[i];
		if(p->selected && p->state != 'T')
			return FALSE;
	}
	return TRUE;
}

// Adjust menu to contain Stop or Continue
void Qps::adjust_popup_menu(QMenu *m, bool cont)
{
	//int idx = m->indexOf(MENU_DETAILS);
	if(procview->treeview==true)
	{
	//	m->setItemVisible (MENU_PARENT,false);
	//	m->setItemVisible (MENU_CHILD,false);
	//	m->setItemVisible (MENU_DYNASTY,false);
	}
	else	
	{
	//	m->setItemVisible (MENU_PARENT,true);
	//	m->setItemVisible (MENU_CHILD,true);
	//	m->setItemVisible (MENU_DYNASTY,true);
	}

	if(procview->viewproc == Procview::HIDDEN) 
	{
	//	m->setItemVisible (MENU_ADD_HIDDEN,false);
	//	m->setItemVisible (MENU_REMOVE_HIDDEN,true);
	}	
	else 
	{
	//	m->setItemVisible (MENU_ADD_HIDDEN,true);
	//	m->setItemVisible (MENU_REMOVE_HIDDEN,false);
	}
}

void Qps::adjust_popup_menu()
{
	bool allstop = all_selected_stopped();
	QList<QAction*> list=m_popup->actions();
	// printf("adjust_popup_menu () size=%d \n",list.size());

	if(allstop)
	for(int i =0 ;i< list.size() - 1 ;i++)
	{
		QAction *act=list[i];
		int id=act->data().toInt();
		if(id==MENU_SIGCONT)	act->setVisible(true);
		if(id==MENU_SIGSTOP)	act->setVisible(false);
	}
	else 
	for(int i =0 ;i< list.size() - 1 ;i++)
	{
		QAction *act=list[i];
		int id=act->data().toInt();
		if(id==MENU_SIGCONT)	act->setVisible(false);
		if(id==MENU_SIGSTOP)	act->setVisible(true);
	}
}

// build signal menu (used in two places)
QMenu *Qps::make_signal_menu()
{
	QMenu *m = new QMenu("Other Signals");
	QAction *act;
	act=m->addAction("SIGINT (interrupt)"); act->setData(MENU_SIGINT);
	act=m->addAction("SIGCONT (continue)"); act->setData(MENU_SIGCONT);
	act=m->addAction("SIGSTOP (stop)"); act->setData(MENU_SIGSTOP);
	act=m->addAction("SIGQUIT (quit)"); act->setData(MENU_SIGQUIT);
	act=m->addAction("SIGILL (illegal instruction)"); act->setData(MENU_SIGILL);
	act=m->addAction("SIGABRT (abort)"); act->setData(MENU_SIGABRT);
	act=m->addAction("SIGFPE (floating point exception)"); act->setData(MENU_SIGFPE);
	act=m->addAction("SIGSEGV (segmentation violation)"); act->setData(MENU_SIGSEGV);
	act=m->addAction("SIGPIPE (broken pipe)"); act->setData(MENU_SIGPIPE);
	act=m->addAction("SIGALRM (timer signal)"); act->setData( MENU_SIGALRM);
	act=m->addAction("SIGUSR1 (user-defined 1)"); act->setData(MENU_SIGUSR1);
	act=m->addAction("SIGUSR2 (user-defined 2)"); act->setData(MENU_SIGUSR2);
	act=m->addAction("SIGCHLD (child death)"); act->setData(MENU_SIGCHLD);
	act=m->addAction("SIGTSTP (stop from tty)"); act->setData(MENU_SIGTSTP);
	act=m->addAction("SIGTTIN (tty input)"); act->setData(MENU_SIGTTIN);
	act=m->addAction("SIGTTOU (tty output)"); act->setData(MENU_SIGTTOU);
	return m;
}


#ifdef MOSIX

// build migrate menu
static int intcmp(const int *a, const int *b)
{
	return *a - *b;
}

QMenu *Qps::make_migrate_menu()
{
	QString buf;
	QMenu *m = new QMenu;
	Svec<int> lst = Procinfo::mosix_nodes();
	lst.sort(intcmp);
	m->insertItem("Home", 1);
	m->insertItem("Find Best", 0);
	for(int i = 0; i < lst.size(); i++) {
		buf.sprintf("to node %d", lst[i]);
		m->insertItem(buf, lst[i] + 1);
	}
	return m;
}
#endif // MOSIX

// update the visibility of the {info, control, status} bar
void Qps::bar_visibility()
{
	update_menu_status();
	if(show_infobar) 
		infobar->show();
 	else 
		infobar->hide();
	
	if(show_ctrlbar) 
		ctrlbar->show();
	else 
		ctrlbar->hide();
	
}

int timer_id;
void Qps::timerEvent(QTimerEvent *e)
{
	timer_id=e->timerId();
	Qps::refresh();
}
//
//dialogs.cpp:    qps->update_timer();
void Qps::update_timer()
{
	killTimer(timer_id); 
	startTimer(update_period); // *** important !!!
}

// change the update period, recomputing the averaging factor
void Qps::set_update_period(int milliseconds)
{
	update_period = milliseconds;
	Procview::avg_factor =	exp(-(float)update_period / Procview::cpu_avg_time);
}

void Qps::refresh()
{
	if(flag_refresh==false) return;

	Procinfo::read_loadavg();
	infobar->update_load(); //
	if(pstable->isVisible())
		pstable->refresh(); 	
	if(netable and netable->isVisible())
		netable->refresh(); 	
	
	if(isVisible()) {
		if(show_infobar) infobar->refresh(); 	// 2
		statusBar->update(Procinfo::num_process);
		update_menu_selection_status(); // update pop menu
	}

	update_icon(); //make icon for systray 
	refresh_details();
}

// need changed !!
// make next timer_refresh happen a little earlier to remove processes that
// might have died after a signal
void Qps::earlier_refresh()
{
	const int delay = 500;	// wait no more than this period (ms)
	if(update_period > delay && update_period != eternity) {
	}
}

//DEL
void Qps::resizeEvent ( QResizeEvent * event )
{
	//DEBUG("Qps::resize()\n");
	//QWidget::resizeEvent(event);
}

/* Don't modify !!!! (by fasthyun@magicn.com) 
 Description :
 	1. only called when in visible() state.
 	2. called when clicked  WINDOW_EXIT_X_Button  
 	3. called when user_logout 
	commitData() ???
*/
void Qps::closeEvent(QCloseEvent *e) 
{
///	DEBUG("DEBUG: closeEvent()....\n");
	if(Qps::flag_exit)
	{
		save_quit();
	}
	else  
	{
		if(trayicon->hasSysTray())
		{	
			e->ignore(); // ignore the exit_signal !!
			hide();
			return;
		}
		e->accept(); // ok. I will be exit Now !! 
	}
}

// call by void Qps::make_command_menu()
//			void signal_handler(int sig)
void Qps::save_quit() // will be removed !!!(by fasthyun@magicn.com) 
{
	//printf("DEBUG: save_quit()....\n");
	close();	// if another window exists, then no exit. // occurs QCoseEvent!
	if(auto_save_options)	write_settings();
	qApp->quit();  // MACRO
}

void Qps::hideEvent ( QHideEvent * event )
{
#ifdef NEW_SYSTRAY
		if(QSystemTrayIcon::isSystemTrayAvailable())
#else
		if(trayicon->hasSysTray())
#endif
		{
			//hide();
		}
//	printf("hideEvent()\n");
//	event->accept();
}

void Qps::enterEvent ( QEvent * event )   
{
//	printf("in!!\n");	
}
void Qps::showEvent ( QShowEvent * event )
{
//	printf("show!!\n");	
	event->accept();
} 
void Qps::mouseMoveEvent ( QMouseEvent * event ) 
{
//	printf("x");
}
void Qps::focusInEvent ( QFocusEvent * event )
{
//	printf("focus\n");
	infobar->showup();
	event->accept();
}
void Qps::moveEvent ( QMoveEvent * event )
{
	infobar->refresh();
	infobar->showup();
	//printf("move\n");
}
void Qps::paintEvent(QPaintEvent *event)
{
//	printf("paintEvent : Qps\n");
//	update_icon();
}
void Qps::update_icon()
{
	if(load_in_icon) set_load_icon(); // always true
	else
		set_default_icon();
}
// called by update_icon()
void Qps::set_default_icon()
{
	if(!default_icon_set) {
		if(!default_icon)
			default_icon = new QPixmap((const char**)icon_xpm);
		setWindowIcon(*default_icon);
		default_icon_set = TRUE;
	}
}
// update table due to a configuration change
// col is column that has changed
// called by 
// 	1.Qps::menu_toggle_cumul()
//	2.Qps::menu_toggle_path()
void Qps::update_table(int col)
{
	/// pstable->repaintColumns(col);
}

// the new vim ruby highlighting It supports much more syntax :package 
// avoid a fvwm/Qt 1.30 problem and create a filled mask for the icon
// (without mask, Qt would attempt to use a heuristically created mask)
void Qps::make_filled_mask(QPixmap *pm)
{
	QBitmap bm(pm->size());
	bm.fill(Qt::color1);
	pm->setMask(bm);
}

void Qps::set_load_icon()
{
	QPixmap *pm = infobar->load_icon(icon_width, icon_height);
	if(!pm->mask())	make_filled_mask(pm);  
#ifdef NEW_SYSTRAY
	if(QSystemTrayIcon::isSystemTrayAvailable()) //always not NULL
#else
	if(trayicon->hasSysTray())
#endif
	{
			trayicon->setIcon(*pm);
			//QString str;
			//str.sprintf("Qps %2.2f%",Procinfo::loadQps);  
			//trayicon->setToolTip(str);
			//trayicon->showMessage("str",str);
	}
	else setWindowIcon(*pm); 

	default_icon_set = FALSE;
}


QPixmap *Qps::get_load_icon()
{
	return infobar->load_icon(icon_width, icon_height);
}

// 
void Qps::refresh_details()
{	
////	details.first();
	////Details d;
#ifdef LINUX
	Procinfo::invalidate_sockets();
#endif

	for(int i=0;i< details.size(); ++i)
	{
		/////Details *d=details[i]
		////if(details[i].isVisible())
			/////details[i].refresh();
	}
	/*
	while((d = details.current()) != 0) {
		if(d->isVisible())
			d->refresh();
		details.next();
	} */
}


// update the menu_status
void Qps::update_menu_status()
{
	update_menu_selection_status();
	//ctrlbar->view->setCurrentItem (procview->viewproc);
	QList<QAction*> list=m_view->actions();

	//for(int i = Procview::USER; i <= Procview::CUSTOM; i++)
	for(int i =0 ;i< list.size() - 1 ;i++)
	{
		QAction *act=list[i];
		act->setCheckable(true);
		int id=act->data().toInt();
		if(id==procview->viewfields)
				act->setChecked(true);
		else 
				act->setChecked(false);
	}
	
	list=m_options->actions();
	for(int i =0 ;i< list.size() - 1 ;i++)
	{
		QAction *act=list[i];
		int id=act->data().toInt();
		
		if(id==MENU_PATH)
			act->setText(show_file_path? "Hide File Path" : "Show File Path");
		else if(id==MENU_INFOBAR)
			act->setText(show_infobar 	? "Hide Graph" : "Show Graph");
		else if(id==MENU_CTRLBAR)
			act->setText(show_ctrlbar	? "Hide Control bar" : "Show Control Bar");
		else if(id==MENU_CUMUL)
			act->setText(cumulative 	? "Exclude Child Times" : "Include Child Times");
	}
	
}

// called when selection changed & update time
// void Qps::update_menu_status()
// void Qps::make_command_menu()
//  Qps::refresh();
void Qps::update_menu_selection_status()
{
	
//	bool enabled = (pstable->numSelected() > 0);
//	if(enabled) 
	{
		bool cont = all_selected_stopped();
		adjust_popup_menu(m_popup, cont);
	}
	
	for(int i = 0; i < commands.size(); i++)
	{
	/*	if (commands[i]->IsNeedProc()==false)
			m_command->setItemEnabled(MENU_FIRST_COMMAND + i, true);
		else	m_command->setItemEnabled(MENU_FIRST_COMMAND + i, enabled);
	*/} 
}


void Qps::sig_term()
{
	send_to_selected(SIGTERM);
}

void Qps::sig_hup()
{
	send_to_selected(SIGHUP);
}

// need
void Qps::sig_stop()
{
	send_to_selected(SIGSTOP);
	
	//test
	for(int i = 0; i < procview->linear_procs.size(); i++) {
		Procinfo *p = procview->linear_procs[i];
		if(p->selected)
		{	p->test_stop=1;   // who ??
			//sendsig(p, sig);
		}
	}
}

void Qps::sig_cont()
{
	send_to_selected(SIGCONT);

	// test
	for(int i = 0; i < procview->linear_procs.size(); i++) {
		Procinfo *p = procview->linear_procs[i];
		if(p->selected)
			p->test_stop=0;
	}

}

void Qps::sig_kill()
{
	send_to_selected(SIGKILL);
}

static struct { int id, sig; } sigtab[] = {
	{ Qps::MENU_SIGQUIT, SIGQUIT },
	{ Qps::MENU_SIGILL, SIGILL },
	{ Qps::MENU_SIGABRT, SIGABRT },
	{ Qps::MENU_SIGFPE, SIGFPE },
	{ Qps::MENU_SIGSEGV, SIGSEGV },
	{ Qps::MENU_SIGPIPE, SIGPIPE },
	{ Qps::MENU_SIGALRM, SIGALRM },
	{ Qps::MENU_SIGUSR1, SIGUSR1 },
	{ Qps::MENU_SIGUSR2, SIGUSR2 },
	{ Qps::MENU_SIGCHLD, SIGCHLD },
	{ Qps::MENU_SIGCONT, SIGCONT },
	{ Qps::MENU_SIGSTOP, SIGSTOP },
	{ Qps::MENU_SIGTSTP, SIGTSTP },
	{ Qps::MENU_SIGTTIN, SIGTTIN },
	{ Qps::MENU_SIGTTOU, SIGTTOU },
	{ Qps::MENU_SIGTERM, SIGTERM },
	{ Qps::MENU_SIGHUP, SIGHUP },
	{ Qps::MENU_SIGINT, SIGINT },
	{ Qps::MENU_SIGKILL, SIGKILL }
};

#define ARRAYSIZE(a) ((int)(sizeof(a)/sizeof((a)[0])))
void Qps::signal_menu(int id)
{
	for(int i = 0; i < ARRAYSIZE(sigtab); i++)
		if(id == sigtab[i].id) {
			send_to_selected(sigtab[i].sig);
			return;
		}
}
void Qps::about()
{
//	QUrl url("http://qps.kldp.net");

	QString s("<h2> qps " QPS_VERSION "  -   A Visual Process Manager </h2> "
#ifdef SOLARIS
#ifdef _LP64
			"64-bit "
#else
			"32-bit "
#endif
			"Solaris version "
#endif // SOLARIS
			"using Qt library "
			);

	s.append(qVersion());
	//s.append(url);
	s.append(
		"<hr>"
		"<b><font color=\"#0000FF\">http://qps.kldp.net</font></b><br>"
		"<center>Bug report to</center>"
		"<center><i>fasthyun@magicn.com </i></center>"
		"<br>"
		"<br>"
		"<center><i>Olivier.Daudel@u-paris10.fr </i></center>"
		"<center><i>jsanchez@todounix.homeip.net </i></center>"
		"<br>"
		"<center>Original Qps by</center>"
		"<center><i>" 
		"	Mattias Engdegrd\n" //"(f91-men@nada.kth.se)\n"
		"</i></center>"
		);
	QMessageBox mb("About qps", s, QMessageBox::NoIcon,
			QMessageBox::Ok | QMessageBox::Default, 0, 0);
//  label.setTextInteractionFlags(Qt::LinksAccessibleByMouse);
	mb.setIconPixmap(QPixmap((const char **)icon_xpm));
	mb.setTextFormat(Qt::RichText);
	mb.exec();
}


void Qps::menu_custom()
{
////	view_menu(Procview::CUSTOM); // should !!
	if(field_win) {
		field_win->update_boxes();
		field_win->show();
		field_win->raise();
	} else {
		field_win = new FieldSelect(procview);
		setWindowGroup(field_win);
		field_win->show();
		connect(field_win, SIGNAL(added_field(int)), this, SLOT(field_added(int)));
		connect(field_win, SIGNAL(removed_field(int)),this, SLOT(field_removed(int)));
	}
}


// MOVE TO PSTABlE
// SLOT:   
// called by 
// 	1.click Tree_checkbox  
//	2.void Qps::view_menu(int id)
void Qps::set_table_mode(bool treemode)
{
//	DEBUG("set_table_mode()\n");
	ctrlbar->setMode(treemode); 	// toggle checkbox
	pstable->setTreeMode(treemode); //first  pstable->refresh(); 	    
	tree_table = treemode; 			// QPS::tree_table  tree/linear mode 
}



// SEGFAULT CODE: 
// called by 
//      1. void Qps::add_fields_menu(int id)
//      2. field_win
void Qps::field_added(int field_id)  
{
	int where=-1; 
	where=pstable->clickedColumn();
	procview->addField(field_id,where);
	//pstable->update(); // repaint 
	pstable->refresh(); // Overhead 
    //update_menu_status();
}

// move to proc
// rewrite! what this hell? SEGFAULT!
// call by 
//	1. FieldSelect 
//	2. void Qps::menu_remove_field()
//
void Qps::field_removed(int index)
{
	procview->removeField(index);

	if(procview->treeview and index == F_COMM) set_table_mode(false); //should be changed to linear mode !!
	if(field_win) field_win->update_boxes();

	update_menu_status(); // ???

	context_col=-1;	// *** important **** : right clicked column removed
//	pstable->update();	// no
	pstable->refresh();
	return;
}


// need to change name , redesign 
void Qps::view_menu(QAction *act)
{
	int id = act->data().toInt();
	int state = id;
	if(id >= Procview::ALL && id <= Procview::HIDDEN) {
		if(procview->viewproc != state) {
			procview->viewproc = state;
		}
	}
	
	if(id >= Procview::USER && id <= Procview::CUSTOM) {
		if(procview->viewfields != state) {
			procview->viewfields = state;
			procview->set_fields();
		}
	}
	pstable->refresh(); // layout 
	update_menu_status();
}


void Qps::menu_edit_cmd()
{
	FUNC_START;
	if(command_win) {
		command_win->show();
		command_win->raise();
	} else {
		command_win = new CommandDialog();
		setWindowGroup(command_win);
		command_win->show();
		connect(command_win, SIGNAL(command_change()),	SLOT(make_command_menu()));
	}
	FUNC_END;

}

void Qps::make_command_menu()
{
	FUNC_START;
//	m_command->clear();
	QAction *act=m_command->addAction("Edit Commands...(under devel)",this, SLOT(menu_edit_cmd()));
	act->setEnabled(false);
////m_command->connectItem(m_command->insertItem("Edit Commands..."),this, SLOT(menu_edit_cmd()));

	if(commands.size())
		m_command->addSeparator();

///	for(int i = 0; i < commands.size(); i++)
//		commands[i]->menu = m_command->insertItem(commands[i]->name, MENU_FIRST_COMMAND + i);

	update_menu_selection_status();
//#ifdef SOLARIS
	/* Solaris CDE don't have a tray, so we need a method to terminate */
//	m_command->insertSeparator();
	m_command->addAction( "&Quit", this, SLOT(save_quit()), Qt::ALT + Qt::Key_Q);
//#endif

	FUNC_END;
}


// run by MENU_ID ?
void Qps::run_command(int command_id)
{
	FUNC_START
	int i,j,idx=-1;
	
	for(i = 0; i < commands.size(); i++) 
	{
		if(commands[i]->menu==command_id)
		{
			idx=i;
			break;
		}
	}
	
	if (idx>=0)
	{
		if (commands[idx]->IsNeedProc()==false)
		{
			commands[idx]->call(NULL);
			return;
		}
	
		for(int i = 0; i < procview->linear_procs.size(); i++) {
			Procinfo *p = procview->linear_procs[i];
			if(p->selected)
				commands[idx]->call(p);
		}
	}

	return;
}

void Qps::menu_add_hiddenlist()
{
	QString str;
	for(int i = 0; i < procview->linear_procs.size(); i++) {
		Procinfo *p = procview->linear_procs[i];
		if(p->selected)
			//hidden_process.add(QString(p->command.ascii()));
			//hidden_process.append(QString(p->command.ascii()));
			hidden_process.append(QString(p->command));
	}
}

// What is this ?
void Qps::menu_remove_hiddenlist()
{
	int idx;
	for(int i = 0; i < procview->linear_procs.size(); i++) {
		Procinfo *p = procview->linear_procs[i];
		if(p->selected)	
		{
			for(int j=0;j<hidden_process.size();j++)
			{
				if(hidden_process[j]==p->command)
					;//hidden_process.erase(j);
					//hidden_process.remove(p->command);
			}
		}
	}
}

// detail
void Qps::Action_Detail()
{
	for(int i = 0; i < procview->linear_procs.size(); i++) {
		Procinfo *p = procview->linear_procs[i];
		if(p->selected)	open_details(i);
	}
}

void Qps::open_details(int row)
{
	Procinfo *p = procview->linear_procs[row];
	if(p->detail)
	{
//		p->detail->raise();
		p->detail->show();
	}
	else {
		Details *d =new Details(p, this, procview);
	//	details.append(*d);
	//	setWindowGroup(d);
		d->show();
	///	connect(d, SIGNAL(closed(Details *)), this, SLOT(details_closed(Details *)));
	}
}

void Qps::details_closed(Details *d)
{
	//printf("details_closed()\n");
	//disconnect 
	
	// This is potentially dangerous, since this is called in response to a
	// signal sent by the widget that is about to be deleted here. Better hope
	// that nobody references the object down the call chain! 
	// what ??????
	
	//////details.removeAt(*d);	// deletes window
	//details.removeAt(*d);	// deletes window
}

// find parents of selected processes
void Qps::menu_parent()
{
	locate_relatives(&Procinfo::ppid, &Procinfo::pid);
}

void Qps::menu_children()
{
	locate_relatives(&Procinfo::pid, &Procinfo::ppid);
}

// Find processes whose attribute b is equal to the attribute a of
// selected processes. Center around topmost found.
// This is quadratic in worst case (shouldn't be a problem)
void Qps::locate_relatives(int Procinfo::*a, int Procinfo::*b)
{
	Svec<int> relatives;
	const int infinity = 2000000000;
	int topmost = infinity;
	for(int i = 0; i < procview->linear_procs.size(); i++) {
		Procinfo *p = procview->linear_procs[i];
		if(p->selected) {
			pstable->setSelected(i, FALSE);
			for(int j = 0; j < procview->linear_procs.size(); j++) {
				Procinfo *q = procview->linear_procs[j];
				if(p->*a == q->*b) {
					relatives.add(j);
					if(j < topmost)
						topmost = j;
				}
			}
		}
	}
	for(int i = 0; i < relatives.size(); i++)
		pstable->setSelected(relatives[i], TRUE);
	///if(topmost < infinity) pstable->centerVertically(topmost);
	///pstable->selectionNotify();
}

// select all (direct and indirect) offsprings of currently selected
// processes, without deselecting them
void Qps::menu_dynasty()
{
	Svec<int> family;
	for(int i = 0; i < procview->linear_procs.size(); i++)
		if(pstable->isSelected(i))
			family.add(i);
	for(int i = 0, j = family.size(); i < j;) {
		for(int k = 0; k < procview->linear_procs.size(); k++) {
			Procinfo *p = procview->linear_procs[k];
			for(int m = i; m < j; m++) {
				Procinfo *q = procview->linear_procs[family[m]];
				if(q->pid == p->ppid)
					family.add(k);
			}
		}
		i = j;
		j = family.size();
	}
	const int infinity = 2000000000;
	int topmost = infinity;
	for(int i = 0; i < family.size(); i++) {
		pstable->setSelected(family[i], TRUE);
		if(family[i] < topmost)
			topmost = family[i];
	}
	////if(topmost < infinity) pstable->centerVertically(topmost);
	////pstable->selectionNotify();
}

// called when right button is clicked in table
void Qps::show_popup_menu(QPoint p)
{
#ifdef MOSIX
	bool may_migrate = FALSE;
	for(int i = 0; i < procview->linear_procs.size(); i++) {
		Procinfo *p = procview->linear_procs[i];
		if(p->selected && p->cantmove.isEmpty()) {
			may_migrate = TRUE;
			break;
		}
	}
	m_popup->setItemEnabled(POPUP_MIGRATE, may_migrate);
#endif
	adjust_popup_menu();	
	m_popup->popup(p);
}


// called when right button is clicked in heading
//
void Qps::context_heading_menu(QPoint p, int col)
{
	static int init=0;
	// rebuild the submenu: only include non-displayed fields
	//int ncats = 0; //procview->allcats.size();
	int ncats=procview->categories.size();
	

	if(init==0)
	{
		#ifdef SHash	
		SHash<int,Category *>::const_iterator it=procview->categories.begin();
		QList<int> keys;
		for ( ; it != procview->categories.end(); it++ )
    		keys.append((*it).first);
		#else
		QList<int> keys=procview->categories.keys();
		#endif
		for(int i = 0; i < ncats; i++)
		{
			Category *cat=procview->categories[keys.takeFirst()];
			QAction *act=m_fields->addAction(cat->name); 
			act->setData(cat->id); 
		}
		connect(m_fields, SIGNAL(triggered(QAction *)),this, SLOT(add_fields_menu(QAction *)));
		init=1;
	}

	QBitArray displayed(ncats);
	displayed.fill(false);

	for(int i = 0; i < procview->cats.size(); i++)
		displayed.setBit(procview->cats[i]->id);

	QList<QAction *> la=m_fields->actions();
	for(int j = 0; j < la.size(); j++)
	{
		QAction *act=la[j];
		int id=act->data().toInt();
		if(!displayed.testBit(id))
			act->setVisible(true);
		else 
			act->setVisible(false);

	}
	context_col = col;
	m_headpopup->popup(p);
}

void Qps::add_fields_menu(QAction *act)
{
	int id = act->data().toInt();
	add_fields_menu(id);
}

// called when field is added from heading context menu
// called by 1. context_heading_menu
void Qps::add_fields_menu(int cat_id)
{
	field_added(cat_id);
	context_col = -1;
	if(field_win)
		field_win->update_boxes();
}

void Qps::menu_remove_field()
{
	if(context_col<0) return;
	field_removed(procview->cats[context_col]->index);
}

void Qps::menu_update()
{

	QString txt;
	if(update_period == eternity)
		txt = "1 s";
	else if(update_period % 1000 == 0)
		txt.sprintf("%d s", update_period / 1000);
	else
		txt.sprintf("%d ms", update_period);
	IntervalDialog id(txt.toAscii().data(), update_period != eternity);
	id.exec();
	/// save_settings();
	return;

}

void Qps::menu_toggle_path()
{	
	show_file_path = !show_file_path;
	update_menu_status();
	int col = procview->findCol(F_CMDLINE);
	if(col != -1)
		update_table(col);
}

void Qps::menu_prefs()
{
	if(prefs_win) {
		prefs_win->show();
		prefs_win->raise();
	} else {
		prefs_win = new Preferences();
		setWindowGroup(prefs_win);
		prefs_win->show();
		prefs_win->raise();

		connect(prefs_win, SIGNAL(prefs_change()),
				this, SLOT(config_change()));
		connect(infobar, SIGNAL(config_change()),
				prefs_win, SLOT(update_boxes()));
	}
}

// if "Preferences" changed
void Qps::config_change()
{
	//DEL infobar->configure();
	///resizeEvent(0);		// in case it caused geometry change
	///pstable->enableFolding(tree_gadgets);
	////pstable->enableLines(tree_lines);
	/////details.first();
	/////Details *d = 0;
	
	for(int i=0;i< details.size(); ++i)
	{
	/////	details[i].config_change();
	}
/*
	while((d = details.current()) != 0) {
		d->config_change();
		details.next();
	} */
}

void Qps::menu_toggle_infobar()
{	
	show_infobar = !show_infobar;
	bar_visibility();
}

void Qps::menu_toggle_ctrlbar()
{
	show_ctrlbar = !show_ctrlbar;
	bar_visibility();
}

void Qps::menu_toggle_cumul()
{
	cumulative = !cumulative;
	update_menu_status();
	int col = procview->findCol(F_TIME);
	if(col == pstable->sortedCol()) {
		procview->rebuild();
		////pstable->transfer_selection();
		////pstable->topAndRepaint();
	} else if(col != -1)
		update_table(col);
}

void Qps::menu_renice()
{
//	if(pstable->hasSelection() == 0)		return;

	int defnice = -1000;

	// use nice of first selected process as default, and check permission
	bool possible = TRUE;
	int euid = geteuid();
	Procinfo *p = 0;

	for(int i = 0; i < procview->linear_procs.size(); i++) {
		p = procview->linear_procs[i];
		if(p->selected) {
			if(defnice == -1000)
				defnice = p->nice;
			if(euid != 0 && euid != p->uid && euid != p->euid)
				possible = FALSE;
		}
	}

	if(!possible) {
		QString s;
		s.sprintf("You do not have permission to renice the\n"
				"selected process%s.\n"
				"Only the process owner and the super-user\n"
				"are allowed to do that.",
				(pstable->hasSelection() == 1) ? "" : "es");
		QMessageBox::warning(this, "Permission denied", s);
		return;
	}
	
	int new_nice;
	for(;;) {
		SliderDialog sd(defnice, -20, 19); // Linux kernel : -20 ~ 19  
		if(!sd.exec())
			return;
		bool ok;
		new_nice = sd.ed_result.toInt(&ok);
		if(ok && new_nice >= -20 && new_nice <= 19)
			break;
	}
	int nicecol = procview->findCol(F_NICE);
	int statcol = procview->findCol(F_STAT);
#ifdef LINUX
	int tmscol = procview->findCol(F_TMS);
#endif

	// do the actual renicing
	for(int i = 0; i < procview->linear_procs.size(); i++) {
		Procinfo *p = procview->linear_procs[i];
		if(p->selected) {
			if(setpriority(PRIO_PROCESS, p->pid, new_nice) < 0) {
				QString s;
				switch(errno) {
					case EPERM:
						// this shouldn't happen, but (e)uid could be changed...
						s.sprintf("You do not have permission to renice"
								" process %d (", p->pid);
						s.append(p->command);
						s.append(").\n"
								"Only the process owner and the super-user are"
								" allowed to do that.");
						QMessageBox::warning(this, "Permission denied", s);
						break;
					case EACCES:
						QMessageBox::warning(this, "Permission denied",
								"Only the super-user may lower"
								" the nice value of a process.");
						return;
				}
			} else {
				p->nice = new_nice; // don't wait for update
#ifdef LINUX
				p->tms = p->get_tms(); //ditto
#endif
			}
		}
	}
}



void Qps::menu_sched()
{
	//if(pstable->hasSelection()==false)	return;
	if(geteuid() != 0) {
		QMessageBox::warning(this, "Permission denied",
				"Only the super-user may change the\n"
				"scheduling policy and static priority.");
		return;
	}

	// provide reasonable defaults (first selected process)
	Procinfo *p = 0;
	for(int i = 0; i < procview->linear_procs.size(); i++) {
		p = procview->linear_procs[i];
		if(p->selected)
			break;
	}
	int pol = p->get_policy();
	int pri = p->get_rtprio();
	SchedDialog sd(pol, pri);
	if(!sd.exec())
		return;

	if(sd.out_policy == SCHED_OTHER)
		sd.out_prio = 0;	// only allowed value
	int plcycol = procview->findCol(F_PLCY);
	int rpricol = procview->findCol(F_RPRI);
#ifdef LINUX
	int tmscol = procview->findCol(F_TMS);
#endif
	for(int i = 0; i < procview->linear_procs.size(); i++) {
		Procinfo *p = procview->linear_procs[i];
		if(p->selected) {
			struct sched_param sp;
			sp.sched_priority = sd.out_prio;
			if(sched_setscheduler(p->pid, sd.out_policy, &sp) < 0) {
				QString s;
				if(errno == EPERM) {
					s.sprintf("You do not have permission to change the\n"
							"scheduling and/or priority of"
							" process %d (", p->pid);
					s.append(p->command);
					s.append(").\n"
							"Only the super-user may do that.");
					QMessageBox::warning(this, "Permission denied", s);
					break;
				}
			} else {
				p->policy = sd.out_policy; // don't wait for update
				p->rtprio = sd.out_prio;
#ifdef LINUX
				p->tms = p->get_tms();
#endif

			}
		}
	}
}


#ifdef MOSIX

void Qps::mig_menu(int id)
{
	migrate_selected(id - 1);
}

void Qps::migrate_selected(int migto)
{
	// User wants to migrate a process somewhere
	// Write destination into /proc/XX/goto
	int warnremote = 0;
	for(int i = 0; i < procview->linear_procs.size(); i++) {
		Procinfo *p = procview->linear_procs[i];
		if(p->selected) {
			if(p->isremote)
				++warnremote;
			char buf[80];
			sprintf(buf, "/proc/%d/goto", p->pid);
			FILE *f = fopen(buf, "w");
			if(f) {
				fprintf(f, "%d", migto);
				fclose(f);
			}
		}
	}
	if (warnremote)
		QMessageBox::warning(this, "Remote migration attempt",
				"You can only migrate an immigrated process "
				"using qps on the home node.");
	earlier_refresh();		
}
#else

// Since this is a slot, at least a stub must be defined even when it isn't
// used (moc ignores preprocessor directives)
void Qps::mig_menu(int) {}

#endif // MOSIX

void Qps::send_to_selected(int sig)
{
	for(int i = 0; i < procview->linear_procs.size(); i++) {
		Procinfo *p = procview->linear_procs[i];
		if(p->selected)
			sendsig(p, sig);
	}
	earlier_refresh();		// in case we killed one
}

void Qps::sendsig(Procinfo *p, int sig)
{
	if(kill(p->pid, sig) < 0) {
		// if the process is gone, do nothing - no need to alert the user
		if(errno == EPERM) {
			QString s;
			s.sprintf("You do not have permission to send a signal to"
					" process %d (", p->pid);
			s.append(p->command);
			s.append(").\n"
					"Only the super-user and the owner of the process"
					" may send signals to it.");
			QMessageBox::warning(this, "Permission denied", s);
			//PermissionDialog *pd = new PermissionDialog(s,supasswd);
			//pd->exec();
		}
	}
}

// write geometry, visible fields and other settings to $HOME/.qps-settings
#define SETTINGS_FILE ".qpsrc"
// If the file format is changed in any way (including adding new
// viewable fields), QPS_FILE_VERSION must be incremented to prevent
// version mismatches and core dumps

#ifdef LINUX
#define QPS_FILE_VERSION 40	// version of .qps-linux file format
#endif

#ifdef SOLARIS
#define QPS_FILE_VERSION 24	// version of .qps-solaris file format
#endif

struct Sflagvar { const char *name; bool *var; };
static Sflagvar  flagvars[] = {
	{ "ExitOnClose", &Qps::flag_exit },
	{ "SingleCPU", &Qps::flag_pcpu_single },
	{ "devel", &Qps::flag_devel },
	{ "cmdpath", &Qps::show_file_path },
	{ "infobar", &Qps::show_infobar },
	{ "ctrlbar", &Qps::show_ctrlbar },
	{ "autosave", &Qps::auto_save_options },
	{ "membar", &Qps::show_mem_bar },
	{ "swapbar", &Qps::show_swap_bar },
	{ "cpubar", &Qps::show_cpu_bar },
	{ "loadgraph", &Qps::show_load_graph },
	{ "loadicon", &Qps::load_in_icon },
	{ "selectpids", &Qps::pids_to_selection },
	{ "tree", &Qps::tree_table },
//	{ "lines", &Qps::tree_lines },
//	{ "cumulative", &Qps::cumulative },
#ifdef LINUX
	{ "hostname", &Qps::hostname_lookup },
	{ "service", &Qps::service_lookup }    
#endif
#ifdef SOLARIS
	{ "normalize", &Qps::normalize_nice },
	{ "pmap", &Qps::use_pmap }
#endif
	,{0,0}
};


char* settings_path(char *name)
{
	char *home = getenv("HOME");
	if(!home) return 0;
	strcpy(name, home);
	strcat(name, "/" SETTINGS_FILE);
	return name;
}

#include <QSettings>
extern QList<watchCond *> watchlist;

bool Qps::read_settings()
{
	char path[512];
	if(settings_path(path)==NULL)
	{
		return false;
	}
	QSettings set(path,QSettings::NativeFormat);

	int v=set.value("version",0).toInt();
	if(v==0)
		return false;
	
	int x, y, w, h;
	x=set.value("geometry/x").toInt();
	y=set.value("geometry/y").toInt();
	w=set.value("geometry/width").toInt();
	h=set.value("geometry/height").toInt();
	//set.value("geometry/visiable",isVisible()); 
	Qps::flag_show=true;
	setGeometry(x, y, w, h);
	font_name=set.value("font/name").toString();
	font_size=set.value("font/size").toInt();
	
	// Field 
	procview->cats.clear();
	QStringList sl=set.value("field").toStringList();
	for(int i=0;i<sl.size();i++)
	{
		QString str=sl[i];
		procview->addField(str.toAscii().data());
	}
	//procview->idxF_COMM=set.value("F_CMD").toInt();

	if(sl.size()==0) // *** for safe , if there is no field. this happen when no qpsrc 
	{
		procview->viewfields = Procview::USER;	
		procview->set_fields();///
	}
	else 
	{
		procview->viewfields = Procview::CUSTOM;
	}

	QString str=set.value("sort").toString(); //procview->sortcat->name);
	int fid=procview->field_id_by_name(str.toAscii().data());
	int col=procview->findCol(fid);
	if(col>=0) pstable->setSortColumn(col);  // refresh! 
	

	sl=set.value("flags").toStringList();
	//for(int i=0;i<sl.size();i++)
	for(Sflagvar *fs = flagvars; fs->name; fs++) 
	{
		if(sl.contains(fs->name))
			*(fs->var)=true;
		else 
			*(fs->var)=false;
	}

	int i=set.value("interval").toInt();
	set_update_period(i);
	//tree_table=set.value("treeview").toBool();
	i=set.value("viewproc").toInt(); 
	procview->viewproc=i; 
	ctrlbar->view->setCurrentIndex (i); //procview->viewproc=set.value("viewproc").toInt(); 

	int size=set.beginReadArray ("watchdog");

 	for(int i = 0; i < size; i++) {
		set.setArrayIndex(i);
		watchCond *w=new watchCond;
		w->putstring(set.value("cat").toString());
		watchlist.append(w);
	}
	set.endArray();	
	return true;
/*
	while(fgets(buf, sizeof(buf), f)) {
		} else if(strcmp(buf, "sort") == 0) {
			char *q = strtok(p, " ");
			Category *cat = proc->cat_by_name(q);
			if(cat) {
				procview->sortcat = cat;
				q = strtok(NULL, " ");
				procview->reversed = (q && strcmp(q, "reversed") == 0);
			}
		} else if(strcmp(buf, "command") == 0) {
			while(*p == ' ') p++;
			bool toolbar;
			QString cmdname = unescape(&p);
			QString cmdline = unescape(&p);
			QString opt = unescape(&p);

			if(opt=="toolbar")
				toolbar=true;
			else
				toolbar=false;

			//printf("opt=%s\n",opt.ascii());
			commands.add(new Command(cmdname, cmdline,toolbar));

			
		} else if(strcmp(buf, "swaplim") == 0) {
			swaplimit = atoi(p);
			swaplim_percent = FALSE;
			if(swaplimit < 0) {
				swaplimit = -swaplimit;
				swaplim_percent = TRUE;
			}
		} else if(strcmp(buf, "interval") == 0) {
			set_update_period(atoi(p));
		}else if(strcmp(buf, "hidden_process") == 0) {
			QString name;
			while(*p!=0)
			{
				name=nextAtom(&p);
			///PAUSED hidden_process.append(QString(name));
			}
		}

	}
	fclose(f); */
	return TRUE;
}


// USING : 
// write geometry, visible fields and other settings to $HOME/.qps-settings
void Qps::write_settings() //save setting
{
	char path[512];
	if(settings_path(path)==NULL)
	{
		return;
	}

	QSettings set(path,QSettings::NativeFormat);
	
	set.setValue("version",QPS_FILE_VERSION);
	//set.beginGroup("");
	//set.endGroup();
	set.setValue("geometry/x",pos().x());
	set.setValue("geometry/y",pos().y());
	set.setValue("geometry/width",width());
	set.setValue("geometry/height",height());
	set.setValue("geometry/visiable",isVisible()); //isVisible() ? "show":"hide");
	set.setValue("viewproc",procview->viewproc); //	all, your, running process...
	set.setValue("treeview",procview->treeview); 

	QStringList sl;
	//printf("procview cats.size=%d\n",procview->cats.size());
    procview->update_customfield();
	set.setValue("field",procview->customfields);
	if(0)
	{
	for(int i = 0; i< procview->cats.size(); i++) //only current field will be saved !!
		sl.append(procview->cats[i]->name);
	set.setValue("field",sl);
	}
	//set.setValue("F_CMD",procview->idxF_COMM);

	if(procview->sortcat)  // sometimes,  sortcat==NULL.
		set.setValue("sort",procview->sortcat->name);//		procview->reversed ? " reversed" : "");
//	return;
	sl.clear();
	for(Sflagvar *fs = flagvars; fs->name; fs++) 
	{
		if(*(fs->var))
			sl.append(fs->name);//fprintf(f, " %s", fs->name);
	}
	set.setValue("flags",sl);

//	fprintf(f,	"swaplim: %d\n"	"interval: %d\n",
//				swaplim_percent ? -swaplimit : swaplimit,
//				update_period);
	
	sl.clear();
	sl.append(font_name);
	sl.append(QString::number(font_size));
	set.setValue("font/name",font_name);
	set.setValue("font/size",font_size); 	//DEL set.setValue("font",sl);
	set.setValue("interval",update_period);

//	set.setValue("watchdog/syscpu",font_size); 	
//	set.setValue("watchdog/procstart",font_size);
	set.beginWriteArray ("watchdog");
 	for(int i = 0; i < watchlist.size(); i++) {
		set.setArrayIndex(i);
		set.setValue("cat", watchlist[i]->getstring());
	}
	set.endArray();
/*	
 *	for(int i = 0; i < commands.size(); i++) {
		fprintf(f, "command: %s,%s",(const char *)commands[i]->name,
				(const char *)commands[i]->cmdline );
		//print_escaped(f, (const char *)commands[i]->name);
		//putc(',', f);
		//print_escaped(f, (const char *)commands[i]->cmdline);
		if(commands[i]->toolbar==true)
			fprintf(f, ",toolbar");
		fprintf(f, "\n");
	}
	fprintf(f, "hidden_process:");
	for(int i = 0; i < hidden_process.size(); i++) {
		if(i!=0) fprintf(f,",");
		fprintf(f,"%s",(const char *)hidden_process[i]);
	}
*/

///	printf("Qps: setting saved !\n");
}

// NEW Version !
// : write geometry, visible fields and other settings to $HOME/.qpsrc
void Qps::save_settings() 
{
	if(Qps::auto_save_options)
		write_settings();
}


// set the window_group hint to that of the main (qps) window
// DELETE ? -> need function , why?
void Qps::setWindowGroup(QWidget *w)
{
		/*
	XWMHints wmh;

	wmh.flags = WindowGroupHint;
	wmh.window_group = handle();
	XSetWMHints(w->x11Display(), w->handle(), &wmh);
*/
}

//DEL
void Qps::setCommand(int argc, char **argv)
{
	// bug: argv[0] should really be frobbed into an absolute path name here
	///XSetCommand(x11Display(), handle(), argv, argc);
}


// return host name with domain stripped
QString short_hostname()
{
	//// int gethostname(char *name, size_t len); // hyun?
	struct utsname u;
	uname(&u);
	char *p = strchr(u.nodename, '.');
	if(p) *p = '\0';
	QString s(u.nodename);
	return s;
}

bool opt_eq(const char *arg, const char *opt)
{
	if(arg[0] == '-') 
		arg++;
	if(arg[0] == '-')
		arg++;

	return strncmp(arg, opt,strlen(opt)) == 0;
}

// print some help to stdout and exit
void print_help(char *cmdname)
{
	fprintf(stderr, "Usage: qps [options]\n"
			"Options:\n"
			"  -version\t\tversion\n"
			"  -mini     \t\tstart Minimized\n");
}



#include	<QX11Info> 
void Qps::clicked_trayicon()
{
	QByteArray ba=saveGeometry ();
	// if hidden 
	if( isMinimized() or isVisible()==false )
	{
		//printf("min_or_hide_window\n");
		showNormal(); // if minimized...
		return;
	}

	// if lower_window   
	// METACITY-2.22.0 bug : XRaiseWindow() not work. 
	if(isActiveWindow()==false)
	{
	//	printf("lower_window\n");
	//	Display *dsp =QX11Info::display (); // get the display(X server?)
 	//	XRaiseWindow( dsp, winId() );
 	//	XMapRaised( dsp, winId() );
	//	printf("x=%d %d g.x=%d %d \n",x(),y(),geometry().x(),geometry().y());
		raise();
		activateWindow();
		return;
	}
//	raise();
//	restoreGeometry(ba);
	hide();

}

void Qps::clicked_trayicon(QSystemTrayIcon::ActivationReason r)
{
//	printf("clicked_trayicon() = %d\n",r);
	if(r==QSystemTrayIcon::Trigger)
	{
		///printf("Trigger = %d\n",r);
		if(!isHidden())
		{
			hide();
		}
		else{
			showNormal(); 
		}
	}

}


// For systray update. 
// this trick very suck, but I can't find a better solution. (by fasthyun@magicn.com)
class QpsApp :public QApplication
{ 
	public:
		QpsApp( int &argc, char ** argv ):QApplication(argc,argv){};
		void commitData ( QSessionManager & sm );
		virtual bool x11EventFilter ( XEvent *xev ){ 
			// catch X11 event for systray_update !!
			if(trayicon!=NULL) 
				return trayicon->checkNewTrayEvent(xev); 
			return false; // events to qt.
		}; 
};


// this is called  when Session Logout 
// closeEvent() called after this
void QpsApp::commitData ( QSessionManager & sm )
{ 
	//DEL sm.release();
	DEBUG("Qps: Session saved\n");
	//sm.setRestartHint (QSessionManager::RestartIfRunning); 
	qps->flag_exit=true;  // ready to Logout
	QApplication::commitData(sm);
} 
#include <signal.h>
void signal_handler(int sig)
{
//	if(sig==SIGINT)	printf("DEBUG: catched SIGINT \n");
//	if(sig==SIGTERM)printf("DEBUG: catched SIGTERM \n");
	qps->save_quit();
	//printf("Qps: suiciding.... wait \n");
	printf("Qps: terminating...\n");
}


int main(int argc, char **argv, char **envp)
{
	signal(SIGTERM, signal_handler);
	signal(SIGINT, signal_handler);
	
	Lookup::initproctitle(argv, envp);	

	for(int i = 1; i < argc; i++) {
		if(opt_eq(argv[i], "version")) {
			fprintf(stderr, "qps version " QPS_VERSION ", using Qt library %s\n", qVersion());
			exit(1);
		} else if(opt_eq(argv[i], "help") || opt_eq(argv[i], "h")) {
			print_help(argv[0]);
			exit(1);
		} 
		else if (opt_eq(argv[i], "session")) 
		{
			flag_session_start=true;
			sleep(5); // **** important !! maybe systray runs later
		} else if (opt_eq(argv[i], "min"))  //mini
		{
			flag_start_mini=true;
		} 
		else if (strstr(argv[i], "screen"))  
		{
			//int screenshot_main(int argc, char **argv);
			//screenshot_main(argc,argv);
			//return 1;
		}
	}
	
	codec = QTextCodec::codecForLocale(); // for Local locale 
	
	QpsApp app(argc, argv);

#ifdef LINUX
	kernel_version=get_kernel_version();
	if(kernel_version< 20600)  // less 2.6 
	{
	    printf("Qps: kernel 2.4.x not supported !!!\n\n"); // because of 2.4.x SMP bugs 
	    exit(0);
	}
#endif
	init_xpm();
	qps=new Qps();
	init_misc(qps);
	
	QString caption = "";  
	caption.append(getenv("USER"));
	caption.append("@");
	caption.append(short_hostname());   //geteuid()
	
	qps->setWindowTitle(UniString(caption));
	qps->setWindowIcon(QPixmap( (const char**)icon_xpm));
    
	if(qps->font_name!="null" and qps->font_name!="default" )
	{
		QFont font(qps->font_name, qps->font_size);
 		QApplication::setFont(font);
	}


	// systray 
	QMenu *menu=new QMenu(qps);
	///menu->addAction( UniString("About"), qps, SLOT(about()) );
	menu->addAction( "Show", qps, SLOT(showNormal()) );
	menu->addAction( "Hide", qps, SLOT(hide()) );
	menu->addSeparator();
	menu->addAction( "ScreenShot", screenshot, SLOT(show()) );
	menu->addAction( "&Quit", qps, SLOT(save_quit()), Qt::ALT + Qt::Key_Q); 


	trayicon=new TrayIcon(QPixmap( (const char**)icon_xpm), "qps", menu);
	QObject::connect(trayicon,SIGNAL(clicked(const QPoint&)),qps,SLOT(clicked_trayicon()));
	QObject::connect(trayicon,SIGNAL(doubleClicked(const QPoint&)),qps,SLOT(clicked_trayicon())); 
	trayicon->sysInstall();
	if(flag_session_start or flag_start_mini ) 
	{
		if(trayicon->hasSysTray())
		{
			qps->hide(); //qps->setHidden(true);
		}
		else 
		{
			qps->showMinimized(); 
		}
	}
	else {
		qps->show();
	//	trayicon->show();
	} 

	return app.exec();
}


