﻿/*
 *  X-IRC Server
 *   Copyright (C) 2004-2009 Paradoxoft Corporation.
 *   Copyright (C) 2009 Stephanos San Io.
 *  
 *  < GNU GPL v3 Terms >
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

using System;
using System.Threading;

namespace Server
{
    static class Program
    {
        public static Core.Database XDatabase;
        public static Provider.ConnexionManager XConnexionManager;
        public static Provider.Monitor XMonitor;
        public static Provider.ChannelManager XChannelManager;

        static void Main(string[] args)
        {
            Console.WriteLine("X-IRC Server");
            Console.WriteLine(" Copyright (C) 2004-2009 Paradoxoft Corporation.");
            Console.WriteLine(" Copyright (C) 2009 Stephanos San Io.");
            Console.WriteLine();
            // Initialise Core
            Console.WriteLine("< Core Initialisation Procedure >");
            // - Database
            Console.Write("Initialising Database...\t\t\t\t\t\t");
            try
            {
                XDatabase = new Core.Database_File();
                Console.WriteLine("Succ");
            }
            catch
            {
                Console.WriteLine("Fail");
                return;
            }
            Console.Write("Loading Database...\t\t\t\t\t\t\t");
            if (XDatabase.Load() == false)
            {
                Console.WriteLine("Fail");
                return;
            }
            Console.WriteLine("Succ");
            Console.WriteLine();
            // Initialise Provider
            Console.WriteLine("< Provider Initialisation Procedure >");
            // - Connexion Manager
            Console.Write("Initialising Connexion Manager ...\t\t\t\t\t");
            try
            {
                XConnexionManager = new Server.Provider.ConnexionManager();
                Console.WriteLine("Succ");
            }
            catch
            {
                Console.WriteLine("Fail");
                return;
            }
            // - Monitor
            Console.Write("Initialising Monitor...\t\t\t\t\t\t\t");
            try
            {
                XMonitor = new Server.Provider.Monitor();
                Console.WriteLine("Succ");
            }
            catch
            {
                Console.WriteLine("Fail");
                return;
            }
            // - Channel Manager
            Console.Write("Initialising Channel Manager ...\t\t\t\t\t");
            try
            {
                XChannelManager = new Server.Provider.ChannelManager();
                Console.WriteLine("Succ");
            }
            catch
            {
                Console.WriteLine("Fail");
                return;
            }
            // - Connexion Acception
            Console.Write("Starting Connexion Acception ...\t\t\t\t\t");
            if (XConnexionManager.StartAcception() == false)
            {
                Console.WriteLine("Fail");
                return;
            }
            Console.WriteLine("Succ");
            // Load Configurations
            Console.WriteLine("< Configuration Load Procedure >");
            // - Initial Channel
            Console.Write("Loading Channel List ...\t\t\t\t\t\t");
            /*if (Core.Configuration.InitialChannelList.Load() == false)
            {
                Console.WriteLine("Fail");
                return;
            }
            Console.WriteLine("Succ");*/
            // - Initial Operator List
            /*Console.Write("Loading Operator List ...\t\t\t\t\t\t");
            if (Core.Configuration.InitialOperatorList.Load() == false)
            {
                Console.WriteLine("Fail");
                return;
            }
            Console.WriteLine("Succ");
            Console.WriteLine();*/

            // TEST SESSION #0001

            // Management Console
            Console.WriteLine();
            Console.WriteLine();
            while (true)
            {
                Console.Write("> ");
                string CommandLine = Console.ReadLine();
                string[] SplitBySpace = CommandLine.Split(' ');
                switch (SplitBySpace[0].ToLower())
                {
                    case "shutdown":
                        Environment.Exit(0);
                        return;
                    case "":
                        break;
                    default:
                        Console.WriteLine("Invalid operation.");
                        break;
                }
            }
        }
    }
}