﻿/*
 *  X-IRC Server
 *   Copyright (C) 2004-2009 Paradoxoft Corporation.
 *   Copyright (C) 2009 Stephanos San Io.
 *  
 *  < GNU GPL v3 Terms >
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

using System;
using System.Collections.Generic;

namespace Server.Provider
{
    class Channel
    {
        public string Name;
        public string Description;

        public SortedList<long, Connexion> ConnexionList;

        public Channel(string Name, string Description)
        {
            this.Name = Name;
            this.Description = Description;
            ConnexionList = new SortedList<long, Connexion>();
        }

        public void ConnexionJoin(Connexion TargetConnexion)
        {
            try
            {
                // JOINING INFORMATION SENDING TO OTHER CHANNEL USERS
                ConnexionList.Add(TargetConnexion.Id, TargetConnexion);
            }
            catch { }
        }

        public void ConnexionLeave(long Id)
        {
            try
            {
                ConnexionList.Remove(Id);
                // LEAVING INFORMATION SENDING TO OTHER CHANNEL USERS
            }
            catch { }
        }
    }   
}